/*
 * Decompiled with CFR 0.152.
 */
package com.julienvey.trello.impl.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.julienvey.trello.TrelloBadRequestException;
import com.julienvey.trello.exception.TrelloHttpException;
import com.julienvey.trello.impl.http.AbstractHttpClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Scanner;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;

public class ApacheHttpClient
extends AbstractHttpClient {
    private DefaultHttpClient httpClient;
    private ObjectMapper mapper;

    public ApacheHttpClient() {
        this(new DefaultHttpClient());
    }

    public ApacheHttpClient(DefaultHttpClient httpClient) {
        this.httpClient = httpClient;
        this.mapper = new ObjectMapper();
    }

    @Override
    public <T> T get(String url, Class<T> objectClass, String ... params) {
        HttpGet httpGet = new HttpGet(this.expandUrl(url, params));
        return this.getEntityAndReleaseConnection(objectClass, (HttpRequestBase)httpGet);
    }

    @Override
    public <T> T postForObject(String url, T object, Class<T> objectClass, String ... params) {
        HttpPost httpPost = new HttpPost(this.expandUrl(url, params));
        try {
            ByteArrayEntity entity = new ByteArrayEntity(this.mapper.writeValueAsBytes(object), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            return this.getEntityAndReleaseConnection(objectClass, (HttpRequestBase)httpPost);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T postFileForObject(String url, File file, Class<T> objectClass, String ... params) {
        HttpPost httpPost = new HttpPost(this.expandUrl(url, params));
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("file", (ContentBody)new FileBody(file));
        try {
            entity.addPart("filename", (ContentBody)new StringBody(file.getName()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        httpPost.setEntity((HttpEntity)entity);
        return this.getEntityAndReleaseConnection(objectClass, (HttpRequestBase)httpPost);
    }

    @Override
    public <T> T putForObject(String url, T object, Class<T> objectClass, String ... params) {
        HttpPut put = new HttpPut(this.expandUrl(url, params));
        try {
            ByteArrayEntity entity = new ByteArrayEntity(this.mapper.writeValueAsBytes(object), ContentType.APPLICATION_JSON);
            put.setEntity((HttpEntity)entity);
            return this.getEntityAndReleaseConnection(objectClass, (HttpRequestBase)put);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URI postForLocation(String url, Object object, String ... params) {
        HttpPost httpPost = new HttpPost(this.expandUrl(url, params));
        try {
            ByteArrayEntity entity = new ByteArrayEntity(this.mapper.writeValueAsBytes(object), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
            Header location = httpResponse.getFirstHeader("Location");
            if (location != null) {
                URI uRI = URI.create(location.getValue());
                return uRI;
            }
            try {
                throw new NullPointerException();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new TrelloHttpException(e);
            }
        }
        finally {
            httpPost.releaseConnection();
        }
    }

    private <T> T getEntityAndReleaseConnection(Class<T> objectClass, HttpRequestBase httpRequest) {
        try {
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                if (httpResponse.getStatusLine().getStatusCode() == 400) {
                    String body = ApacheHttpClient.toString(httpEntity.getContent());
                    throw new TrelloBadRequestException(body);
                }
                Object object = this.mapper.readValue(httpEntity.getContent(), objectClass);
                return (T)object;
            }
            try {
                throw new NullPointerException();
            }
            catch (IOException e) {
                throw new TrelloHttpException(e);
            }
        }
        finally {
            httpRequest.releaseConnection();
        }
    }

    private static String toString(InputStream stream) {
        return new Scanner(stream).useDelimiter("\\A").next();
    }
}

