/*
 * Decompiled with CFR 0.152.
 */
package com.julienvey.trello.impl.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.julienvey.trello.exception.TrelloHttpException;
import com.julienvey.trello.impl.http.AbstractHttpClient;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;

public class AsyncTrelloHttpClient2
extends AbstractHttpClient {
    private final AsyncHttpClient asyncHttpClient;
    private final ObjectReader reader;
    private final ObjectWriter writer;

    public AsyncTrelloHttpClient2() {
        this((AsyncHttpClient)new DefaultAsyncHttpClient(), new ObjectMapper());
    }

    public AsyncTrelloHttpClient2(AsyncHttpClient asyncHttpClient, ObjectMapper mapper) {
        this(asyncHttpClient, mapper.reader(), mapper.writer());
    }

    public AsyncTrelloHttpClient2(AsyncHttpClient asyncHttpClient, ObjectReader reader, ObjectWriter writer) {
        this.asyncHttpClient = asyncHttpClient;
        this.reader = reader;
        this.writer = writer;
    }

    @Override
    public <T> T get(String url, final Class<T> objectClass, String ... params) {
        try {
            ListenableFuture f = this.asyncHttpClient.prepareGet(this.expandUrl(url, params)).execute((AsyncHandler)new AsyncCompletionHandler<T>(){

                public T onCompleted(Response response) throws Exception {
                    return AsyncTrelloHttpClient2.this.reader.forType(objectClass).readValue(response.getResponseBody());
                }

                public void onThrowable(Throwable t) {
                    throw new TrelloHttpException(t);
                }
            });
            return (T)f.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new TrelloHttpException(e);
        }
    }

    @Override
    public <T> T postForObject(String url, T object, final Class<T> objectClass, String ... params) {
        try {
            byte[] body = this.writer.writeValueAsBytes(object);
            ListenableFuture f = ((BoundRequestBuilder)this.asyncHttpClient.preparePost(this.expandUrl(url, params)).setBody(body)).execute((AsyncHandler)new AsyncCompletionHandler<T>(){

                public T onCompleted(Response response) throws Exception {
                    return AsyncTrelloHttpClient2.this.reader.forType(objectClass).readValue(response.getResponseBody());
                }

                public void onThrowable(Throwable t) {
                    throw new TrelloHttpException(t);
                }
            });
            return (T)f.get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new TrelloHttpException(e);
        }
    }

    @Override
    public URI postForLocation(String url, Object object, String ... params) {
        try {
            byte[] body = this.writer.writeValueAsBytes(object);
            ListenableFuture f = ((BoundRequestBuilder)this.asyncHttpClient.preparePost(this.expandUrl(url, params)).setBody(body)).execute((AsyncHandler)new AsyncCompletionHandler<URI>(){

                public URI onCompleted(Response response) {
                    String location = response.getHeader((CharSequence)"Location");
                    if (location != null) {
                        return URI.create(location);
                    }
                    throw new TrelloHttpException("Location header not set");
                }

                public void onThrowable(Throwable t) {
                    throw new TrelloHttpException(t);
                }
            });
            return (URI)f.get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new TrelloHttpException(e);
        }
    }

    @Override
    public <T> T putForObject(String url, T object, final Class<T> objectClass, String ... params) {
        try {
            byte[] body = this.writer.writeValueAsBytes(object);
            ListenableFuture f = ((BoundRequestBuilder)this.asyncHttpClient.preparePut(this.expandUrl(url, params)).setBody(body)).execute((AsyncHandler)new AsyncCompletionHandler<T>(){

                public T onCompleted(Response response) throws Exception {
                    return AsyncTrelloHttpClient2.this.reader.forType(objectClass).readValue(response.getResponseBody());
                }

                public void onThrowable(Throwable t) {
                    throw new TrelloHttpException(t);
                }
            });
            return (T)f.get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new TrelloHttpException(e);
        }
    }
}

