/*
 * Decompiled with CFR 0.152.
 */
package com.textkernel.tx.services;

import com.textkernel.tx.EnvironmentSettings;
import com.textkernel.tx.exceptions.TxException;
import com.textkernel.tx.http.HttpResponse;
import com.textkernel.tx.models.api.matchV2.autocomplete.AutocompleteCandidatesField;
import com.textkernel.tx.models.api.matchV2.autocomplete.AutocompleteJobsField;
import com.textkernel.tx.models.api.matchV2.autocomplete.AutocompleteRequest;
import com.textkernel.tx.models.api.matchV2.autocomplete.AutocompleteResponse;
import com.textkernel.tx.models.api.matchV2.documents.AddCandidateRequest;
import com.textkernel.tx.models.api.matchV2.documents.AddCandidateResponse;
import com.textkernel.tx.models.api.matchV2.documents.AddJobRequest;
import com.textkernel.tx.models.api.matchV2.documents.AddJobResponse;
import com.textkernel.tx.models.api.matchV2.documents.DeleteDocumentsResponse;
import com.textkernel.tx.models.api.matchV2.documents.DocumentSource;
import com.textkernel.tx.models.api.matchV2.querying.MatchRequest;
import com.textkernel.tx.models.api.matchV2.querying.Options;
import com.textkernel.tx.models.api.matchV2.querying.SearchQuery;
import com.textkernel.tx.models.api.matchV2.querying.SearchResponse;
import com.textkernel.tx.models.job.ParsedJob;
import com.textkernel.tx.models.resume.ParsedResume;
import com.textkernel.tx.services.ServiceBase;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class MatchV2Service
extends ServiceBase {
    public MatchV2Service(OkHttpClient httpClient, EnvironmentSettings settings) {
        super(httpClient, settings);
    }

    public AddCandidateResponse addCandidate(String documentId, ParsedResume resume, List<String> roles, boolean anonymize, Map<String, String> customFields) throws TxException {
        AddCandidateRequest request = new AddCandidateRequest();
        request.Anonymize = anonymize;
        request.ResumeData = resume;
        request.Roles = roles;
        request.SearchAndMatchEnvironment = this._settings.MatchV2Environment;
        request.CustomFields = customFields;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchV2CandidatesAddDocument(documentId)).post(body).build();
        HttpResponse<AddCandidateResponse> response = this.executeRequest(apiRequest, AddCandidateResponse.class, MatchV2Service.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public AddJobResponse addJob(String documentId, ParsedJob job, List<String> roles, Map<String, String> customFields) throws TxException {
        AddJobRequest request = new AddJobRequest();
        request.JobData = job;
        request.Roles = roles;
        request.SearchAndMatchEnvironment = this._settings.MatchV2Environment;
        request.CustomFields = customFields;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchV2JobsAddDocument(documentId)).post(body).build();
        HttpResponse<AddJobResponse> response = this.executeRequest(apiRequest, AddJobResponse.class, MatchV2Service.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public DeleteDocumentsResponse deleteCandidates(List<String> documentIds) throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.matchV2CandidatesDeleteDocuments(documentIds, this._settings.MatchV2Environment.toString())).delete().build();
        HttpResponse<DeleteDocumentsResponse> response = this.executeRequest(apiRequest, DeleteDocumentsResponse.class, MatchV2Service.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public DeleteDocumentsResponse deleteJobs(List<String> documentIds) throws TxException {
        Request apiRequest = new Request.Builder().url(this._endpoints.matchV2JobsDeleteDocuments(documentIds, this._settings.MatchV2Environment.toString())).delete().build();
        HttpResponse<DeleteDocumentsResponse> response = this.executeRequest(apiRequest, DeleteDocumentsResponse.class, MatchV2Service.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    private SearchResponse matchInternal(Options options, SearchQuery query, DocumentSource sourceDocument, String url) throws TxException {
        MatchRequest request = new MatchRequest();
        request.Options = options;
        request.SearchAndMatchEnvironment = this._settings.MatchV2Environment;
        request.Query = query;
        request.SourceDocument = sourceDocument;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(url).post(body).build();
        HttpResponse<SearchResponse> response = this.executeRequest(apiRequest, SearchResponse.class, MatchV2Service.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    private SearchResponse searchInternal(Options options, SearchQuery query, String url) throws TxException {
        return this.matchInternal(options, query, null, url);
    }

    public SearchResponse matchCandidates(DocumentSource sourceDocument, Options options, SearchQuery query) throws TxException {
        return this.matchInternal(options, query, sourceDocument, this._endpoints.matchV2CandidatesMatchDocument());
    }

    public SearchResponse matchJobs(DocumentSource sourceDocument, Options options, SearchQuery query) throws TxException {
        return this.matchInternal(options, query, sourceDocument, this._endpoints.matchV2JobsMatchDocument());
    }

    public SearchResponse searchCandidates(SearchQuery query, Options options) throws TxException {
        return this.searchInternal(options, query, this._endpoints.matchV2CandidatesSearch());
    }

    public SearchResponse searchJobs(SearchQuery query, Options options) throws TxException {
        return this.searchInternal(options, query, this._endpoints.matchV2JobsSearch());
    }

    private <T> AutocompleteResponse autocompleteInternal(String url, T field, String input, String ... languages) throws TxException {
        AutocompleteRequest request = new AutocompleteRequest();
        request.Field = field;
        request.Input = input;
        request.SearchAndMatchEnvironment = this._settings.MatchV2Environment;
        request.Language = String.join((CharSequence)",", languages);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(url).post(body).build();
        HttpResponse<AutocompleteResponse> response = this.executeRequest(apiRequest, AutocompleteResponse.class, MatchV2Service.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public AutocompleteResponse autocompleteCandidates(AutocompleteCandidatesField field, String input, String ... languages) throws TxException {
        return this.autocompleteInternal(this._endpoints.matchV2CandidatesAutocomplete(), field, input, languages);
    }

    public AutocompleteResponse autocompleteJobs(AutocompleteJobsField field, String input, String ... languages) throws TxException {
        return this.autocompleteInternal(this._endpoints.matchV2JobsAutocomplete(), field, input, languages);
    }
}

