/*
 * Decompiled with CFR 0.152.
 */
package com.tokenwatcher;

import com.tokenwatcher.Event;
import com.tokenwatcher.EventBuffer;
import com.tokenwatcher.TokenWatcherConfig;
import com.tokenwatcher.Utils;
import java.time.Instant;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMonitoredClient {
    private static final Logger logger = LoggerFactory.getLogger(BaseMonitoredClient.class);
    protected final TokenWatcherConfig config;
    protected final EventBuffer buffer;
    protected final Map<String, Object> defaultMetadata;

    protected BaseMonitoredClient(TokenWatcherConfig config, Map<String, Object> metadata) {
        this.config = config;
        this.buffer = new EventBuffer(config);
        this.defaultMetadata = metadata != null ? Utils.sanitizeMetadata(metadata) : null;
    }

    protected Event createSuccessEvent(String provider, String model, Integer inputTokens, Integer outputTokens, long latencyMs, String context) {
        return Event.builder().timestamp(Instant.now().toString()).provider(provider).model(model).inputTokens(inputTokens).outputTokens(outputTokens).latencyMs(latencyMs).success(true).context(context != null ? context : this.config.getContext()).userIdentifier(this.config.getUserIdentifier()).metadata(this.defaultMetadata).build();
    }

    protected Event createErrorEvent(String provider, String model, long latencyMs, Throwable error, String context) {
        return Event.builder().timestamp(Instant.now().toString()).provider(provider).model(model).latencyMs(latencyMs).success(false).errorMessage(Utils.extractErrorMessage(error)).errorType(Utils.extractErrorType(error)).context(context != null ? context : this.config.getContext()).userIdentifier(this.config.getUserIdentifier()).metadata(this.defaultMetadata).build();
    }

    protected String getContext() {
        String context = this.config.getContext();
        if (context == null) {
            context = Utils.getCallerContext();
        }
        return context;
    }

    public void flush() {
        this.buffer.flush();
    }

    public void shutdown() {
        this.buffer.shutdown();
    }
}

