/*
 * Decompiled with CFR 0.152.
 */
package com.tokenwatcher;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Event {
    @JsonProperty(value="timestamp")
    private String timestamp;
    @JsonProperty(value="provider")
    private String provider;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="inputTokens")
    private Integer inputTokens;
    @JsonProperty(value="outputTokens")
    private Integer outputTokens;
    @JsonProperty(value="latencyMs")
    private Long latencyMs;
    @JsonProperty(value="success")
    private Boolean success;
    @JsonProperty(value="errorMessage")
    private String errorMessage;
    @JsonProperty(value="errorType")
    private String errorType;
    @JsonProperty(value="context")
    private String context;
    @JsonProperty(value="userIdentifier")
    private String userIdentifier;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata;

    private Event() {
    }

    private Event(Builder builder) {
        this.timestamp = builder.timestamp;
        this.provider = builder.provider;
        this.model = builder.model;
        this.inputTokens = builder.inputTokens;
        this.outputTokens = builder.outputTokens;
        this.latencyMs = builder.latencyMs;
        this.success = builder.success;
        this.errorMessage = builder.errorMessage;
        this.errorType = builder.errorType;
        this.context = builder.context;
        this.userIdentifier = builder.userIdentifier;
        this.metadata = builder.metadata;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getModel() {
        return this.model;
    }

    public Integer getInputTokens() {
        return this.inputTokens;
    }

    public Integer getOutputTokens() {
        return this.outputTokens;
    }

    public Long getLatencyMs() {
        return this.latencyMs;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getContext() {
        return this.context;
    }

    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String timestamp = Instant.now().toString();
        private String provider;
        private String model;
        private Integer inputTokens;
        private Integer outputTokens;
        private Long latencyMs;
        private Boolean success;
        private String errorMessage;
        private String errorType;
        private String context;
        private String userIdentifier;
        private Map<String, Object> metadata;

        public Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder inputTokens(Integer inputTokens) {
            this.inputTokens = inputTokens;
            return this;
        }

        public Builder outputTokens(Integer outputTokens) {
            this.outputTokens = outputTokens;
            return this;
        }

        public Builder latencyMs(Long latencyMs) {
            this.latencyMs = latencyMs;
            return this;
        }

        public Builder success(Boolean success) {
            this.success = success;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        public Builder context(String context) {
            this.context = context;
            return this;
        }

        public Builder userIdentifier(String userIdentifier) {
            this.userIdentifier = userIdentifier;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Event build() {
            return new Event(this);
        }
    }
}

