/*
 * Decompiled with CFR 0.152.
 */
package com.tokenwatcher;

import com.tokenwatcher.Event;
import com.tokenwatcher.EventSender;
import com.tokenwatcher.TokenWatcherConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBuffer {
    private static final Logger logger = LoggerFactory.getLogger(EventBuffer.class);
    private final TokenWatcherConfig config;
    private final EventSender sender;
    private final List<Event> buffer;
    private final Lock lock;
    private final ScheduledExecutorService scheduler;
    private volatile boolean running;

    public EventBuffer(TokenWatcherConfig config) {
        this.config = config;
        this.sender = new EventSender(config);
        this.buffer = new ArrayList<Event>();
        this.lock = new ReentrantLock();
        this.running = false;
        if (config.isEnabled()) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = new Thread(r, "tokenwatcher-flush");
                t.setDaemon(true);
                return t;
            });
            this.startFlushThread();
        } else {
            this.scheduler = null;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    public void addEvent(Event event) {
        int bufferSize;
        if (!this.config.isEnabled()) {
            return;
        }
        this.lock.lock();
        try {
            this.buffer.add(event);
            bufferSize = this.buffer.size();
        }
        finally {
            this.lock.unlock();
        }
        if (bufferSize >= this.config.getBufferSize()) {
            logger.debug("Buffer full ({} events), triggering flush", (Object)bufferSize);
            this.flush();
        }
    }

    public void flush() {
        ArrayList<Event> eventsToSend;
        if (!this.config.isEnabled()) {
            return;
        }
        this.lock.lock();
        try {
            if (this.buffer.isEmpty()) {
                return;
            }
            eventsToSend = new ArrayList<Event>(this.buffer);
            this.buffer.clear();
        }
        finally {
            this.lock.unlock();
        }
        logger.debug("Flushing {} events", (Object)eventsToSend.size());
        this.sender.sendBatch(eventsToSend);
    }

    private void startFlushThread() {
        this.running = true;
        this.scheduler.scheduleAtFixedRate(this::periodicFlush, this.config.getFlushInterval(), this.config.getFlushInterval(), TimeUnit.SECONDS);
        logger.debug("Started flush thread with interval {}s", (Object)this.config.getFlushInterval());
    }

    private void periodicFlush() {
        try {
            this.flush();
        }
        catch (Exception e) {
            logger.error("Error in periodic flush: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void shutdown() {
        logger.debug("Shutting down event buffer");
        this.running = false;
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(2L, TimeUnit.SECONDS)) {
                    this.scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        try {
            this.flush();
        }
        catch (Exception e) {
            logger.error("Error during shutdown flush: {}", (Object)e.getMessage());
        }
        this.sender.close();
        logger.debug("Event buffer shutdown complete");
    }
}

