/*
 * Decompiled with CFR 0.152.
 */
package com.tokenwatcher;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String extractErrorType(Throwable exception) {
        return exception.getClass().getSimpleName();
    }

    public static String extractErrorMessage(Throwable exception) {
        Object message = exception.getMessage();
        if (message == null) {
            message = exception.getClass().getName();
        }
        if (((String)message).length() > 1000) {
            message = ((String)message).substring(0, 997) + "...";
        }
        return message;
    }

    public static Map<String, Object> sanitizeMetadata(Map<String, Object> metadata) {
        if (metadata == null) {
            return null;
        }
        try {
            objectMapper.writeValueAsString(metadata);
            return metadata;
        }
        catch (JsonProcessingException e) {
            logger.warn("Metadata is not JSON-serializable: {}", (Object)e.getMessage());
            HashMap<String, Object> fallback = new HashMap<String, Object>();
            fallback.put("_raw", metadata.toString());
            return fallback;
        }
    }

    public static String getCallerContext() {
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = 4; i < stackTrace.length; ++i) {
                StackTraceElement element = stackTrace[i];
                String className = element.getClassName();
                if (className.startsWith("com.tokenwatcher")) continue;
                String methodName = element.getMethodName();
                String context = className + "." + methodName;
                if (context.length() > 200) {
                    context = context.substring(0, 197) + "...";
                }
                logger.debug("Auto-detected context: {}", (Object)context);
                return context;
            }
            logger.debug("Could not auto-detect caller context");
            return null;
        }
        catch (Exception e) {
            logger.warn("Error auto-detecting caller context: {}", (Object)e.getMessage());
            return null;
        }
    }
}

