/*
 * Decompiled with CFR 0.152.
 */
package unquietcode.utils;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public final class RandomUtils {
    private static final Random randomSource = new Random();
    private static final Random secureRandomSource = new SecureRandom();
    private static final char[] URL_SAFE_BASE_64_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
    private static final char[] SUPER_SAFE_TABLE = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    private RandomUtils() {
    }

    public static int randomInt(int max) {
        if (max < 0) {
            throw new IllegalArgumentException("non-negative only");
        }
        return randomSource.nextInt(max);
    }

    public static <T> Iterator<T> weightedRandomSelection(Map<T, Double> mapping) {
        final ArrayList<AbstractMap.SimpleEntry<T, Double>> entries = new ArrayList<AbstractMap.SimpleEntry<T, Double>>(mapping.size());
        for (Map.Entry<T, Double> entry : mapping.entrySet()) {
            entries.add(new AbstractMap.SimpleEntry<T, Double>(entry.getKey(), entry.getValue()));
        }
        Collections.sort(entries, new Comparator<Map.Entry<T, Double>>(){

            @Override
            public int compare(Map.Entry<T, Double> o1, Map.Entry<T, Double> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        double total = 0.0;
        for (Map.Entry entry : entries) {
            entry.setValue(total += ((Double)entry.getValue()).doubleValue());
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                double random = randomSource.nextDouble();
                for (Map.Entry entry : entries) {
                    if (!(random <= (Double)entry.getValue())) continue;
                    return entry.getKey();
                }
                return ((Map.Entry)entries.get(entries.size() - 1)).getKey();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String getRandomKey(int base) {
        BigInteger randomPart = BigInteger.valueOf(secureRandomSource.nextInt(Integer.MAX_VALUE));
        BigInteger timePart = BigInteger.valueOf(System.currentTimeMillis());
        BigInteger value = timePart.shiftLeft(32);
        value = value.or(randomPart);
        return value.toString(base).toUpperCase();
    }

    public static String getRandomBase64Key(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = secureRandomSource.nextInt(URL_SAFE_BASE_64_TABLE.length);
            sb.append(URL_SAFE_BASE_64_TABLE[index]);
        }
        return sb.toString();
    }

    public static String getRandomSafeKey(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = secureRandomSource.nextInt(SUPER_SAFE_TABLE.length);
            sb.append(SUPER_SAFE_TABLE[index]);
        }
        return sb.toString();
    }

    public static <K, V> Map<K, V> randomize(Map<K, V> map) {
        return RandomUtils.randomize(map, map.size());
    }

    public static <K, V> Map<K, V> randomize(Map<K, V> map, int size) {
        if (size == map.size()) {
            return new HashMap<K, V>(map);
        }
        if (size > map.size()) {
            throw new RuntimeException("Not enough elements.");
        }
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        HashMap<K, V> retval = new HashMap<K, V>();
        while (retval.size() < size) {
            Map.Entry<K, V> entry = entries.get(randomSource.nextInt(entries.size()));
            if (retval.containsKey(entry.getKey())) continue;
            retval.put(entry.getKey(), entry.getValue());
        }
        return retval;
    }

    public static <T> List<T> randomize(List<T> list) {
        list = new ArrayList<T>(list);
        ArrayList<T> randomized = new ArrayList<T>(list.size());
        while (!list.isEmpty()) {
            int idx = randomSource.nextInt(list.size());
            T element = list.remove(idx);
            randomized.add(element);
        }
        return randomized;
    }
}

