/*
 * Decompiled with CFR 0.152.
 */
package unquietcode.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import unquietcode.utils.CollectionUtils;
import unquietcode.utils.Conditionals;

public class StringUtils {
    public static boolean startsWithAny(String string, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!string.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithAnyCI(String string, String ... prefixes) {
        string = string.toLowerCase();
        for (String prefix : prefixes) {
            if (!string.startsWith(prefix.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithAny(String string, String ... suffixes) {
        for (String suffix : suffixes) {
            if (!string.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithAnyCI(String string, String ... suffixes) {
        string = string.toLowerCase();
        for (String suffix : suffixes) {
            if (!string.endsWith(suffix.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsAny(String string, String ... others) {
        return Conditionals.equalsAny(string, others);
    }

    public static boolean equalsAnyCI(String string, String ... others) {
        for (String other : others) {
            if (!string.equalsIgnoreCase(other)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static boolean hasText(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static boolean areEmpty(String ... args) {
        for (String str : CollectionUtils.safe(args)) {
            if (!StringUtils.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean areNotEmpty(String ... args) {
        return !StringUtils.areEmpty(args);
    }

    public static boolean anyAreEmpty(String ... strings) {
        for (String string : strings) {
            if (!StringUtils.isEmpty(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean noneAreEmpty(String ... strings) {
        return !StringUtils.anyAreEmpty(strings);
    }

    public static String requireNonEmpty(String string) {
        return StringUtils.requireNonEmpty(string, "a valid string is required");
    }

    public static String requireNonEmpty(String string, String message) {
        if (StringUtils.isEmpty(string)) {
            throw new IllegalArgumentException(message);
        }
        return string;
    }

    public static String reverse(String string) {
        StringBuilder sb = new StringBuilder(string);
        sb = sb.reverse();
        return sb.toString();
    }

    public static void match(String text, String prefix, String suffix, Consumer<String> consumer) {
        int prefixStart;
        int prefixLength = prefix.length();
        int suffixLength = suffix.length();
        int current = 0;
        while ((prefixStart = text.indexOf(prefix, current)) > -1) {
            if (prefixStart != 0 && text.charAt(prefixStart - 1) == '\\') {
                current = prefixStart + prefixLength;
                continue;
            }
            int suffixStart = text.indexOf(suffix, prefixStart + prefixLength);
            if (suffixStart > -1) {
                if (suffixStart != 0 && text.charAt(suffixStart - 1) == '\\') {
                    current = suffixStart + suffixLength;
                    continue;
                }
                int matchStart = prefixStart + prefixLength;
                String substring = text.substring(matchStart, suffixStart);
                substring = substring.replace("\\", "");
                consumer.accept(substring);
                current = suffixStart + suffixLength;
                continue;
            }
            current = prefixStart + prefixLength;
        }
    }

    public static String join(String ... strings) {
        return StringUtils.join(null, strings);
    }

    public static String join(Collection<String> strings) {
        return StringUtils.join(null, strings);
    }

    public static String join(String delineator, String ... strings) {
        return StringUtils.join(delineator, Arrays.asList(strings));
    }

    public static String join(String delineator, Collection<String> strings) {
        return StringUtils.join(delineator, strings, null);
    }

    public static String join(String delineator, Collection<String> strings, Function<String, String> fn) {
        if (delineator == null) {
            delineator = " ";
        }
        if (fn == null) {
            fn = Function.identity();
        }
        StringBuilder string = new StringBuilder();
        boolean first = true;
        for (String s : strings) {
            if (first) {
                first = false;
            } else {
                string.append(delineator);
            }
            s = fn.apply(s);
            string.append(s);
        }
        return string.toString();
    }
}

