/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.google.common.base.Preconditions;
import com.urbanairship.api.client.APIClientResponse;
import com.urbanairship.api.client.APIPushResponse;
import com.urbanairship.api.client.APIScheduleResponse;
import com.urbanairship.api.client.PushAPIResponseHandler;
import com.urbanairship.api.client.ScheduleAPIResponseHandler;
import com.urbanairship.api.push.model.PushPayload;
import com.urbanairship.api.schedule.model.SchedulePayload;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIClient {
    private static final String CONTENT_TYPE_KEY = "Content-type";
    private static final String ACCEPT_KEY = "Accept";
    private static final String UA_APPLICATION_JSON = "application/vnd.urbanairship+json;";
    private static final String USER_AGENT = "UrbanAirship/version0.1beta";
    private static final String API_PUSH_PATH = "/api/push/";
    private static final String API_VALIDATE_PATH = "/api/validate/";
    private static final String API_SCHEDULE_PATH = "/api/schedules/";
    private final String appKey;
    private final String appSecret;
    private final URI baseURI;
    private final Number version;
    private final HttpHost uaHost;
    private static final String UA_HOSTNAME = "go.urbanairship.com";
    private static final Logger logger = LoggerFactory.getLogger((String)"com.urbanairship.api");

    public static Builder newBuilder() {
        return new Builder();
    }

    private APIClient(String appKey, String appSecret, String baseURI, Number version) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)appKey), (Object)"App key must be provided.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)appSecret), (Object)"App secret must be provided");
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.baseURI = URI.create(baseURI);
        this.version = version;
        this.uaHost = new HttpHost(UA_HOSTNAME, 443, "https");
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getAppKey() {
        return this.appKey;
    }

    private String versionedAcceptHeader(Number version) {
        return String.format("%s version=%s", UA_APPLICATION_JSON, version.toString());
    }

    private Request pushRequest(PushPayload payload, String path) {
        URI uri = this.baseURI.resolve(path);
        return Request.Post((URI)uri).config("http.useragent", (Object)USER_AGENT).addHeader(CONTENT_TYPE_KEY, this.versionedAcceptHeader(this.version)).addHeader(ACCEPT_KEY, this.versionedAcceptHeader(this.version)).bodyString(payload.toJSON(), ContentType.APPLICATION_JSON);
    }

    private Request scheduleRequest(SchedulePayload payload, String path, String httpMethod) {
        Request request;
        URI uri = this.baseURI.resolve(path);
        if (httpMethod.equals("POST")) {
            request = Request.Post((URI)uri);
            request.bodyString(payload.toJSON(), ContentType.APPLICATION_JSON);
        } else if (httpMethod.equals("GET")) {
            request = Request.Get((URI)uri);
        } else if (httpMethod.equals("PUT")) {
            request = Request.Put((URI)uri);
            request.bodyString(payload.toJSON(), ContentType.APPLICATION_JSON);
        } else if (httpMethod.equals("DELETE")) {
            request = Request.Delete((URI)uri);
        } else {
            throw new IllegalArgumentException(String.format("Schedule requests support POST/GET/DELETE/PUT HTTP %s Method passed", httpMethod));
        }
        return request.config("http.useragent", (Object)USER_AGENT).addHeader(CONTENT_TYPE_KEY, this.versionedAcceptHeader(this.version)).addHeader(ACCEPT_KEY, this.versionedAcceptHeader(this.version));
    }

    private APIClientResponse<APIPushResponse> executePushRequest(Request request) throws IOException {
        Executor executor = Executor.newInstance().auth(this.uaHost, this.appKey, this.appSecret).authPreemptive(this.uaHost);
        logger.debug(String.format("Executing push request %s", request));
        return (APIClientResponse)executor.execute(request).handleResponse((ResponseHandler)new PushAPIResponseHandler());
    }

    public APIClientResponse<APIPushResponse> validate(PushPayload payload) throws IOException {
        Request request = this.pushRequest(payload, API_VALIDATE_PATH);
        return this.executePushRequest(request);
    }

    public APIClientResponse<APIPushResponse> push(PushPayload payload) throws IOException {
        Request request = this.pushRequest(payload, API_PUSH_PATH);
        return this.executePushRequest(request);
    }

    private APIClientResponse<APIScheduleResponse> executeScheduleRequest(Request request) throws IOException {
        Executor executor = Executor.newInstance().auth(this.uaHost, this.appKey, this.appSecret).authPreemptive(this.uaHost);
        logger.debug(String.format("Executing schedule request %s", request));
        return (APIClientResponse)executor.execute(request).handleResponse((ResponseHandler)new ScheduleAPIResponseHandler());
    }

    public APIClientResponse<APIScheduleResponse> schedule(SchedulePayload payload) throws IOException {
        Request request = this.scheduleRequest(payload, API_SCHEDULE_PATH, "POST");
        return this.executeScheduleRequest(request);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("APIClient");
        stringBuilder.append("\nAppKey:");
        stringBuilder.append(this.appKey);
        stringBuilder.append("\nAppSecret:");
        stringBuilder.append(this.appSecret);
        return stringBuilder.toString();
    }

    public static class Builder {
        private String key;
        private String secret;
        private String baseURI = "https://go.urbanairship.com";
        private Number version = 3;

        private Builder() {
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setSecret(String appSecret) {
            this.secret = appSecret;
            return this;
        }

        public Builder setBaseURI(String URI) {
            this.baseURI = URI;
            return this;
        }

        public Builder setVersion(Number version) {
            this.version = version;
            return this;
        }

        public APIClient build() {
            return new APIClient(this.key, this.secret, this.baseURI, this.version);
        }
    }
}

