/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.urbanairship.api.client.APIPushResponse;
import com.urbanairship.api.client.APIScheduleResponse;
import org.apache.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIClientResponse<T> {
    private final T apiResponse;
    private final HttpResponse httpResponse;

    private APIClientResponse(T apiResponse, HttpResponse httpResponse) {
        this.apiResponse = apiResponse;
        this.httpResponse = httpResponse;
    }

    public static Builder<APIPushResponse> newPushResponseBuilder() {
        return new Builder<APIPushResponse>();
    }

    public static Builder<APIScheduleResponse> newScheduleResponseBuilder() {
        return new Builder<APIScheduleResponse>();
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public T getApiResponse() {
        return this.apiResponse;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\nHttp:");
        builder.append(this.httpResponse.toString());
        builder.append("\nAPI:");
        builder.append(this.apiResponse.toString());
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T> {
        private T apiResponse;
        private HttpResponse httpResponse;

        private Builder() {
        }

        public Builder<T> setApiResponse(T apiResponse) {
            this.apiResponse = apiResponse;
            return this;
        }

        public Builder<T> setHttpResponse(HttpResponse httpResponse) {
            this.httpResponse = httpResponse;
            return this;
        }

        public APIClientResponse<T> build() {
            return new APIClientResponse(this.apiResponse, this.httpResponse);
        }
    }
}

