/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.google.common.base.Optional;
import com.urbanairship.api.client.APIError;
import java.io.IOException;
import org.apache.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIRequestException
extends RuntimeException {
    private final HttpResponse httpResponse;
    private final Optional<APIError> error;

    private APIRequestException(String message, HttpResponse httpResponse, Optional<APIError> error, Throwable cause) {
        super(message, cause);
        this.httpResponse = httpResponse;
        this.error = error;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public Optional<APIError> getError() {
        return this.error;
    }

    public int httpResponseStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    public String httpResponseStatusMessage() {
        return this.httpResponse.getStatusLine().getReasonPhrase();
    }

    public static APIRequestException exceptionForResponse(HttpResponse response) throws IOException {
        APIError apiError = APIError.errorFromResponse(response);
        return APIRequestException.newBuilder().setMessage(response.getStatusLine().getReasonPhrase()).setApiError(apiError).setHttpResponse(response).build();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nAPIRequestException:");
        stringBuilder.append(String.format("\nMessage:%s", this.getMessage()));
        stringBuilder.append(String.format("\nHttpResponse:%s", this.httpResponse.toString()));
        if (this.error.isPresent()) {
            stringBuilder.append(String.format("\nError:%s", this.error.get()));
        }
        if (this.getCause() != null) {
            stringBuilder.append(String.format("\nCause:%s", this.getCause().getMessage()));
        }
        return stringBuilder.toString();
    }

    public static class Builder {
        private String message;
        private HttpResponse httpResponse;
        private APIError apiError;
        private Throwable cause;

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setHttpResponse(HttpResponse httpResponse) {
            this.httpResponse = httpResponse;
            return this;
        }

        public Builder setApiError(APIError apiError) {
            this.apiError = apiError;
            return this;
        }

        public Builder setCause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public APIRequestException build() {
            return new APIRequestException(this.message, this.httpResponse, Optional.fromNullable((Object)this.apiError), this.cause);
        }
    }
}

