/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.urbanairship.api.client.APIClientResponse;
import com.urbanairship.api.client.APIPushResponse;
import com.urbanairship.api.client.APIRequestException;
import com.urbanairship.api.client.parse.APIResponseObjectMapper;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushAPIResponseHandler
implements ResponseHandler<APIClientResponse<APIPushResponse>> {
    private final Logger logger = LoggerFactory.getLogger((String)"com.urbanairship.api");

    PushAPIResponseHandler() {
    }

    public APIClientResponse<APIPushResponse> handleResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        switch (statusCode) {
            case 202: {
                this.logger.debug(String.format("Handling response code:%s", statusCode));
                return this.handleSuccessfulPush(response);
            }
            case 400: 
            case 401: 
            case 406: {
                throw APIRequestException.exceptionForResponse(response);
            }
        }
        if (statusCode >= 200 && statusCode < 300) {
            return this.handleSuccessfulPush(response);
        }
        throw APIRequestException.exceptionForResponse(response);
    }

    private APIClientResponse<APIPushResponse> handleSuccessfulPush(HttpResponse response) throws IOException {
        String jsonPayload = EntityUtils.toString((HttpEntity)response.getEntity());
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        ObjectMapper mapper = APIResponseObjectMapper.getInstance();
        APIPushResponse pushResponse = (APIPushResponse)mapper.readValue(jsonPayload, APIPushResponse.class);
        APIClientResponse.Builder<APIPushResponse> builder = APIClientResponse.newPushResponseBuilder();
        builder.setApiResponse(pushResponse);
        builder.setHttpResponse(response);
        return builder.build();
    }
}

