/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.NotificationPayloadOverrideKey;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Notification
extends PushModelObject {
    private final Optional<String> alert;
    private final ImmutableMap<NotificationPayloadOverrideKey, ? extends DevicePayloadOverride> deviceTypePayloadOverrides;

    public static Builder newBuilder() {
        return new Builder();
    }

    private Notification(Optional<String> alert, ImmutableMap<NotificationPayloadOverrideKey, ? extends DevicePayloadOverride> deviceTypePayloadOverrides) {
        this.alert = alert;
        this.deviceTypePayloadOverrides = deviceTypePayloadOverrides;
    }

    public Optional<String> getAlert() {
        return this.alert;
    }

    public Optional<ImmutableSet<DeviceType>> getOverrideDeviceTypes() {
        if (this.deviceTypePayloadOverrides == null || this.deviceTypePayloadOverrides.size() == 0) {
            return Optional.absent();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (NotificationPayloadOverrideKey key : this.deviceTypePayloadOverrides.keySet()) {
            builder.add((Object)key.getDeviceType());
        }
        return Optional.of((Object)builder.build());
    }

    public <O extends DevicePayloadOverride> Optional<O> getDeviceTypeOverride(DeviceType deviceType, Class<O> overrideType) {
        return Optional.fromNullable((Object)((DevicePayloadOverride)this.deviceTypePayloadOverrides.get((Object)new NotificationPayloadOverrideKey(deviceType, overrideType))));
    }

    public Map<DeviceType, DevicePayloadOverride> getDeviceTypePayloadOverrides() {
        HashMap overrides = Maps.newHashMap();
        for (Map.Entry entry : this.deviceTypePayloadOverrides.entrySet()) {
            overrides.put(((NotificationPayloadOverrideKey)entry.getKey()).getDeviceType(), entry.getValue());
        }
        return overrides;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification that = (Notification)o;
        if (this.alert != null ? !this.alert.equals(that.alert) : that.alert != null) {
            return false;
        }
        return !(this.deviceTypePayloadOverrides != null ? !this.deviceTypePayloadOverrides.equals(that.deviceTypePayloadOverrides) : that.deviceTypePayloadOverrides != null);
    }

    public int hashCode() {
        int result = this.alert != null ? this.alert.hashCode() : 0;
        result = 31 * result + (this.deviceTypePayloadOverrides != null ? this.deviceTypePayloadOverrides.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Notification{alert=" + this.alert + ", deviceTypePayloadOverrides=" + this.deviceTypePayloadOverrides + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final ImmutableMap.Builder<NotificationPayloadOverrideKey, DevicePayloadOverride> deviceTypePayloadOverridesBuilder = ImmutableMap.builder();
        private String alert = null;

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public <P extends DevicePayloadOverride> Builder addDeviceTypeOverride(DeviceType deviceType, P payload) {
            this.deviceTypePayloadOverridesBuilder.put((Object)new NotificationPayloadOverrideKey(deviceType, payload.getClass()), payload);
            return this;
        }

        public Notification build() {
            ImmutableMap overrides = this.deviceTypePayloadOverridesBuilder.build();
            Preconditions.checkArgument((this.alert != null || !overrides.isEmpty() ? 1 : 0) != 0, (Object)"Must either specify default notification keys or at least a single deviceType override");
            return new Notification(Optional.fromNullable((Object)this.alert), overrides);
        }
    }
}

