/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.wns;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WNSBinding {
    private final String template;
    private final Optional<Integer> version;
    private final Optional<String> fallback;
    private final Optional<String> lang;
    private final Optional<String> baseUri;
    private final Optional<Boolean> addImageQuery;
    private final Optional<ImmutableList<String>> images;
    private final Optional<ImmutableList<String>> text;

    private WNSBinding(String template, Optional<Integer> version, Optional<String> fallback, Optional<String> lang, Optional<String> baseUri, Optional<Boolean> addImageQuery, Optional<ImmutableList<String>> images, Optional<ImmutableList<String>> text) {
        this.template = template;
        this.version = version;
        this.fallback = fallback;
        this.lang = lang;
        this.baseUri = baseUri;
        this.addImageQuery = addImageQuery;
        this.images = images;
        this.text = text;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getTemplate() {
        return this.template;
    }

    public Optional<Integer> getVersion() {
        return this.version;
    }

    public Optional<String> getFallback() {
        return this.fallback;
    }

    public Optional<String> getLang() {
        return this.lang;
    }

    public Optional<String> getBaseUri() {
        return this.baseUri;
    }

    public Optional<Boolean> getAddImageQuery() {
        return this.addImageQuery;
    }

    public int getImageCount() {
        return this.images.isPresent() ? ((ImmutableList)this.images.get()).size() : 0;
    }

    public String getImage(int i) {
        return (String)((ImmutableList)this.images.get()).get(i);
    }

    public Optional<ImmutableList<String>> getImages() {
        return this.images;
    }

    public int getTextCount() {
        return this.text.isPresent() ? ((ImmutableList)this.text.get()).size() : 0;
    }

    public String getText(int i) {
        return (String)((ImmutableList)this.text.get()).get(i);
    }

    public Optional<ImmutableList<String>> getText() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WNSBinding that = (WNSBinding)o;
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.fallback != null ? !this.fallback.equals(that.fallback) : that.fallback != null) {
            return false;
        }
        if (this.lang != null ? !this.lang.equals(that.lang) : that.lang != null) {
            return false;
        }
        if (this.baseUri != null ? !this.baseUri.equals(that.baseUri) : that.baseUri != null) {
            return false;
        }
        if (this.addImageQuery != null ? !this.addImageQuery.equals(that.addImageQuery) : that.addImageQuery != null) {
            return false;
        }
        if (this.images != null ? !this.images.equals(that.images) : that.images != null) {
            return false;
        }
        return !(this.text != null ? !this.text.equals(that.text) : that.text != null);
    }

    public int hashCode() {
        int result = this.template != null ? this.template.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.fallback != null ? this.fallback.hashCode() : 0);
        result = 31 * result + (this.lang != null ? this.lang.hashCode() : 0);
        result = 31 * result + (this.baseUri != null ? this.baseUri.hashCode() : 0);
        result = 31 * result + (this.addImageQuery != null ? this.addImageQuery.hashCode() : 0);
        result = 31 * result + (this.images != null ? this.images.hashCode() : 0);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private String template;
        private Integer version;
        private String fallback;
        private String lang;
        private String baseUri;
        private Boolean addImageQuery;
        private ImmutableList.Builder<String> images;
        private ImmutableList.Builder<String> text;

        private Builder() {
        }

        public Builder setTemplate(String value) {
            this.template = value;
            return this;
        }

        public Builder setVersion(Integer value) {
            this.version = value;
            return this;
        }

        public Builder setFallback(String value) {
            this.fallback = value;
            return this;
        }

        public Builder setLang(String value) {
            this.lang = value;
            return this;
        }

        public Builder setBaseUri(String value) {
            this.baseUri = value;
            return this;
        }

        public Builder setAddImageQuery(boolean value) {
            this.addImageQuery = value;
            return this;
        }

        public Builder addImage(String value) {
            if (this.images == null) {
                this.images = ImmutableList.builder();
            }
            this.images.add((Object)value);
            return this;
        }

        public Builder addAllImages(Iterable<String> values) {
            if (this.images == null) {
                this.images = ImmutableList.builder();
            }
            this.images.addAll(values);
            return this;
        }

        public Builder addText(String value) {
            if (this.text == null) {
                this.text = ImmutableList.builder();
            }
            this.text.add((Object)value);
            return this;
        }

        public Builder addAllText(Iterable<String> values) {
            if (this.text == null) {
                this.text = ImmutableList.builder();
            }
            this.text.addAll(values);
            return this;
        }

        public WNSBinding build() {
            if (this.template == null) {
                throw new IllegalArgumentException("Must supply a value for 'template'.");
            }
            return new WNSBinding(this.template, Optional.fromNullable((Object)this.version), Optional.fromNullable((Object)this.fallback), Optional.fromNullable((Object)this.lang), Optional.fromNullable((Object)this.baseUri), Optional.fromNullable((Object)this.addImageQuery), Optional.fromNullable(this.images != null ? this.images.build() : null), Optional.fromNullable(this.text != null ? this.text.build() : null));
        }
    }
}

