/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.mpns;

import com.google.common.collect.ImmutableList;
import com.urbanairship.api.push.model.notification.mpns.MPNSCycleTileData;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPNSCycleTileSerializer
extends JsonSerializer<MPNSCycleTileData> {
    public void serialize(MPNSCycleTileData tile, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (tile.getCount().isPresent()) {
            jgen.writeNumberField("count", ((Integer)tile.getCount().get()).intValue());
        }
        if (tile.getTitle().isPresent()) {
            jgen.writeStringField("title", (String)tile.getTitle().get());
        }
        if (tile.getId().isPresent()) {
            jgen.writeStringField("id", (String)tile.getId().get());
        }
        jgen.writeStringField("template", tile.getTemplate());
        if (tile.getSmallBackgroundImage().isPresent()) {
            jgen.writeStringField("small_background_image", (String)tile.getSmallBackgroundImage().get());
        }
        if (tile.getImageCount() > 0) {
            jgen.writeArrayFieldStart("cycle_image");
            for (String image : (ImmutableList)tile.getImages().get()) {
                jgen.writeString(image);
            }
            jgen.writeEndArray();
        }
        jgen.writeEndObject();
    }
}

