/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.information.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.urbanairship.api.channel.information.model.DeviceType;
import com.urbanairship.api.channel.information.model.ios.IosSettings;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChannelView {
    private final String channelId;
    private final DeviceType deviceType;
    private final boolean installed;
    private final boolean optedIn;
    private final Optional<Boolean> background;
    private final Optional<String> pushAddress;
    private final long createdMillis;
    private final Optional<Long> lastRegistrationMillis;
    private final Optional<String> alias;
    private final ImmutableSet<String> tags;
    private final Optional<IosSettings> iosSettings;

    public ChannelView(String channelId, DeviceType deviceType, boolean installed, boolean optedIn, Optional<Boolean> background, Optional<String> pushAddress, long createdMillis, Optional<Long> lastRegistrationMillis, Optional<String> alias, ImmutableSet<String> tags, Optional<IosSettings> iosSettings) {
        this.channelId = channelId;
        this.deviceType = deviceType;
        this.installed = installed;
        this.optedIn = optedIn;
        this.background = background;
        this.pushAddress = pushAddress;
        this.createdMillis = createdMillis;
        this.lastRegistrationMillis = lastRegistrationMillis;
        this.alias = alias;
        this.tags = tags;
        this.iosSettings = iosSettings;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getChannelId() {
        return this.channelId;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public boolean isOptedIn() {
        return this.optedIn;
    }

    public Optional<Boolean> getBackground() {
        return this.background;
    }

    public Optional<String> getPushAddress() {
        return this.pushAddress;
    }

    public long getCreatedMillis() {
        return this.createdMillis;
    }

    public Optional<Long> getLastRegistrationMillis() {
        return this.lastRegistrationMillis;
    }

    public Optional<String> getAlias() {
        return this.alias;
    }

    public ImmutableSet<String> getTags() {
        return this.tags;
    }

    public Optional<IosSettings> getIosSettings() {
        return this.iosSettings;
    }

    public String toString() {
        return "ChannelView{channelId='" + this.channelId + '\'' + ", deviceType=" + (Object)((Object)this.deviceType) + ", installed=" + this.installed + ", optedIn=" + this.optedIn + ", background=" + this.background + ", pushAddress=" + this.pushAddress + ", createdMillis=" + this.createdMillis + ", lastRegistrationMillis=" + this.lastRegistrationMillis + ", alias=" + this.alias + ", tags=" + this.tags + ", iosSettings=" + this.iosSettings + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.channelId, this.deviceType, this.installed, this.optedIn, this.background, this.pushAddress, this.createdMillis, this.lastRegistrationMillis, this.alias, this.tags, this.iosSettings});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelView other = (ChannelView)obj;
        return Objects.equal((Object)this.channelId, (Object)other.channelId) && Objects.equal((Object)((Object)this.deviceType), (Object)((Object)other.deviceType)) && Objects.equal((Object)this.installed, (Object)other.installed) && Objects.equal((Object)this.optedIn, (Object)other.optedIn) && Objects.equal(this.background, other.background) && Objects.equal(this.pushAddress, other.pushAddress) && Objects.equal((Object)this.createdMillis, (Object)other.createdMillis) && Objects.equal(this.lastRegistrationMillis, other.lastRegistrationMillis) && Objects.equal(this.alias, other.alias) && Objects.equal(this.tags, other.tags) && Objects.equal(this.iosSettings, other.iosSettings);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        private final ImmutableSet.Builder<String> tags = ImmutableSet.builder();
        private String channelId = null;
        private DeviceType deviceType = null;
        private Boolean optedIn = null;
        private Boolean installed = null;
        private Boolean background = null;
        private String pushAddress = null;
        private Long createdMillis = null;
        private Long lastRegistrationMillis = null;
        private String alias = null;
        private IosSettings iosSettings = null;

        private Builder() {
        }

        public Builder setChannelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder setDeviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public Builder setInstalled(Boolean installed) {
            this.installed = installed;
            return this;
        }

        public Builder setOptedIn(Boolean optedIn) {
            this.optedIn = optedIn;
            return this;
        }

        public Builder setBackground(Boolean background) {
            this.background = background;
            return this;
        }

        public Builder setPushAddress(String pushAddress) {
            this.pushAddress = pushAddress;
            return this;
        }

        public Builder setCreatedMillis(Long createdMillis) {
            this.createdMillis = createdMillis;
            return this;
        }

        public Builder setLastRegistrationMillis(Long lastRegistrationMillis) {
            this.lastRegistrationMillis = lastRegistrationMillis;
            return this;
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder addAllTags(Iterable<String> tags) {
            Preconditions.checkNotNull(tags);
            for (String tag : tags) {
                this.tags.add((Object)tag);
            }
            return this;
        }

        public Builder addTag(String tag) {
            if (StringUtils.isNotBlank((String)tag)) {
                this.tags.add((Object)tag);
            }
            return this;
        }

        public Builder setIosSettings(IosSettings iosSettings) {
            this.iosSettings = iosSettings;
            return this;
        }

        public ChannelView build() {
            Preconditions.checkNotNull((Object)this.channelId);
            Preconditions.checkNotNull((Object)((Object)this.deviceType));
            Preconditions.checkNotNull((Object)this.installed);
            Preconditions.checkNotNull((Object)this.optedIn);
            Preconditions.checkNotNull((Object)this.createdMillis);
            return new ChannelView(this.channelId, this.deviceType, this.installed, this.optedIn, (Optional<Boolean>)Optional.fromNullable((Object)this.background), (Optional<String>)Optional.fromNullable((Object)this.pushAddress), this.createdMillis, (Optional<Long>)Optional.fromNullable((Object)this.lastRegistrationMillis), (Optional<String>)Optional.fromNullable((Object)this.alias), (ImmutableSet<String>)this.tags.build(), (Optional<IosSettings>)Optional.fromNullable((Object)this.iosSettings));
        }
    }
}

