/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.information.parse;

import com.urbanairship.api.channel.information.model.ChannelView;
import com.urbanairship.api.channel.information.model.DeviceType;
import com.urbanairship.api.channel.information.model.ios.IosSettings;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.BooleanFieldDeserializer;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.ListOfStringsDeserializer;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChannelViewReader
implements JsonObjectReader<ChannelView> {
    private final ChannelView.Builder builder = ChannelView.newBuilder();

    public void readChannelId(JsonParser jsonParser) throws IOException {
        this.builder.setChannelId(StringFieldDeserializer.INSTANCE.deserialize(jsonParser, "channel_id"));
    }

    public void readDeviceType(JsonParser jsonParser) throws IOException {
        this.builder.setDeviceType((DeviceType)((Object)jsonParser.readValueAs(DeviceType.class)));
    }

    public void readInstalled(JsonParser jsonParser) throws IOException {
        this.builder.setInstalled(BooleanFieldDeserializer.INSTANCE.deserialize(jsonParser, "installed"));
    }

    public void readOptIn(JsonParser jsonParser) throws IOException {
        this.builder.setOptedIn(BooleanFieldDeserializer.INSTANCE.deserialize(jsonParser, "opt_in"));
    }

    public void readBackground(JsonParser jsonParser) throws IOException {
        this.builder.setBackground(BooleanFieldDeserializer.INSTANCE.deserialize(jsonParser, "background"));
    }

    public void readPushAddress(JsonParser jsonParser) throws IOException {
        this.builder.setPushAddress((String)jsonParser.readValueAs(String.class));
    }

    public void readCreated(JsonParser jsonParser) throws IOException {
        this.builder.setCreatedMillis(((DateTime)jsonParser.readValueAs(DateTime.class)).getMillis());
    }

    public void readLastRegistration(JsonParser jsonParser) throws IOException {
        DateTime dt = (DateTime)jsonParser.readValueAs(DateTime.class);
        Long mills = dt == null ? null : Long.valueOf(dt.getMillis());
        this.builder.setLastRegistrationMillis(mills);
    }

    public void readAlias(JsonParser jsonParser) throws IOException {
        this.builder.setAlias((String)jsonParser.readValueAs(String.class));
    }

    public void readTags(JsonParser jsonParser) throws IOException {
        this.builder.addAllTags(ListOfStringsDeserializer.INSTANCE.deserialize(jsonParser, "tags"));
    }

    public void readIosSettings(JsonParser jsonParser) throws IOException {
        this.builder.setIosSettings((IosSettings)jsonParser.readValueAs(IosSettings.class));
    }

    @Override
    public ChannelView validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }
}

