/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.google.common.base.Optional;
import com.urbanairship.api.client.APIErrorDetails;
import com.urbanairship.api.client.parse.APIResponseObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APIError {
    private static final String CONTENT_TYPE_KEY = "Content-type";
    private static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String UA_APPLICATION_JSON = "application/vnd.urbanairship+json";
    private final boolean ok;
    private final Optional<String> operationId;
    private final String error;
    private final Optional<Number> errorCode;
    private final Optional<APIErrorDetails> details;

    private APIError(boolean ok, Optional<String> operationId, String error, Optional<Number> errorCode, Optional<APIErrorDetails> details) {
        this.ok = ok;
        this.operationId = operationId;
        if (error == null || error.isEmpty()) {
            throw new IllegalArgumentException("Error cannot be null or empty");
        }
        this.error = error;
        this.errorCode = errorCode;
        this.details = details;
    }

    public static APIError errorFromResponse(HttpResponse response) throws IOException {
        HeaderElement[] headerElements = response.getFirstHeader(CONTENT_TYPE_KEY).getElements();
        String contentType = headerElements[0].getName();
        if (contentType.equalsIgnoreCase(CONTENT_TYPE_TEXT_HTML)) {
            return APIError.nonJSONError(response);
        }
        if (contentType.equalsIgnoreCase(CONTENT_TYPE_JSON)) {
            return APIError.nonV3JSONError(response);
        }
        if (contentType.equalsIgnoreCase(UA_APPLICATION_JSON)) {
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            ObjectMapper mapper = APIResponseObjectMapper.getInstance();
            return (APIError)mapper.readValue(responseBody, APIError.class);
        }
        return APIError.newBuilder().setError("Unknown response parsing error").build();
    }

    @Deprecated
    private static APIError nonJSONError(HttpResponse response) throws IOException {
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        return APIError.newBuilder().setError(responseBody).build();
    }

    @Deprecated
    private static APIError nonV3JSONError(HttpResponse response) throws IOException {
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        EntityUtils.consume((HttpEntity)response.getEntity());
        ObjectMapper mapper = APIResponseObjectMapper.getInstance();
        Map errorMsg = (Map)mapper.readValue(responseBody, (TypeReference)new TypeReference<Map<String, String>>(){});
        return APIError.newBuilder().setError((String)errorMsg.get("message")).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public Optional<String> getOperationId() {
        return this.operationId;
    }

    public String getError() {
        return this.error;
    }

    public Optional<Number> getErrorCode() {
        return this.errorCode;
    }

    public Optional<APIErrorDetails> getDetails() {
        return this.details;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ok:");
        stringBuilder.append(this.getOk());
        stringBuilder.append("\nAPIError:");
        stringBuilder.append(this.getError());
        stringBuilder.append("\nCode:");
        stringBuilder.append(this.getErrorCode());
        if (this.details.isPresent()) {
            stringBuilder.append("\nDetails:");
            stringBuilder.append(((APIErrorDetails)this.details.get()).toString());
        }
        return stringBuilder.toString();
    }

    public static class Builder {
        private boolean ok;
        private String operationId;
        private String error;
        private Number errorCode;
        private APIErrorDetails details;

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setOperationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorCode(Number errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder setDetails(APIErrorDetails details) {
            this.details = details;
            return this;
        }

        public APIError build() {
            return new APIError(this.ok, Optional.fromNullable((Object)this.operationId), this.error, Optional.fromNullable((Object)this.errorCode), Optional.fromNullable((Object)this.details));
        }
    }
}

