/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.urbanairship.api.client.APIRequestException;
import com.urbanairship.api.client.model.APIClientResponse;
import com.urbanairship.api.client.parse.APIResponseObjectMapper;
import com.urbanairship.api.reports.model.AppStats;
import java.io.IOException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListAppStatsAPIResponseHandler
implements ResponseHandler<APIClientResponse<List<AppStats>>> {
    private static final ObjectMapper mapper = APIResponseObjectMapper.getInstance();
    private static final APIClientResponse.Builder<List<AppStats>> builder = APIClientResponse.newListAppStatsBuilder();

    public APIClientResponse<List<AppStats>> handleResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return this.handleSuccessfulResponse(response);
        }
        throw APIRequestException.exceptionForResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIClientResponse<List<AppStats>> handleSuccessfulResponse(HttpResponse response) throws IOException {
        builder.setHttpResponse(response);
        try {
            String jsonPayload = EntityUtils.toString((HttpEntity)response.getEntity());
            List listOfAppStats = (List)mapper.readValue(jsonPayload, (TypeReference)new TypeReference<List<AppStats>>(){});
            builder.setApiResponse(listOfAppStats);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        return builder.build();
    }
}

