/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.urbanairship.api.client.APIRequestException;
import com.urbanairship.api.client.model.APIClientResponse;
import com.urbanairship.api.client.parse.APIResponseObjectMapper;
import com.urbanairship.api.reports.model.PerPushSeriesResponse;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPerPushSeriesResponseHandler
implements ResponseHandler<APIClientResponse<PerPushSeriesResponse>> {
    private static final ObjectMapper mapper = APIResponseObjectMapper.getInstance();
    private static final APIClientResponse.Builder<PerPushSeriesResponse> builder = APIClientResponse.newListPerPushSeriesBuilder();

    public APIClientResponse<PerPushSeriesResponse> handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return this.handleSuccessfulResponse(httpResponse);
        }
        throw APIRequestException.exceptionForResponse(httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIClientResponse<PerPushSeriesResponse> handleSuccessfulResponse(HttpResponse response) throws IOException {
        builder.setHttpResponse(response);
        try {
            String jsonPayload = EntityUtils.toString((HttpEntity)response.getEntity());
            PerPushSeriesResponse obj = (PerPushSeriesResponse)mapper.readValue(jsonPayload, PerPushSeriesResponse.class);
            builder.setApiResponse(obj);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        return builder.build();
    }
}

