/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.urbanairship.api.client.APIRequestException;
import com.urbanairship.api.client.model.APIClientResponse;
import com.urbanairship.api.client.model.APIListSingleChannelResponse;
import com.urbanairship.api.client.parse.APIResponseObjectMapper;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListSingleChannelAPIResponseHandler
implements ResponseHandler<APIClientResponse<APIListSingleChannelResponse>> {
    private static final ObjectMapper mapper = APIResponseObjectMapper.getInstance();
    private static final APIClientResponse.Builder<APIListSingleChannelResponse> builder = APIClientResponse.newSingleChannelResponseBuilder();

    public APIClientResponse<APIListSingleChannelResponse> handleResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return this.handleSuccessfulRequest(response);
        }
        throw APIRequestException.exceptionForResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIClientResponse<APIListSingleChannelResponse> handleSuccessfulRequest(HttpResponse response) throws IOException {
        builder.setHttpResponse(response);
        try {
            String jsonPayload = EntityUtils.toString((HttpEntity)response.getEntity());
            APIListSingleChannelResponse channelsResponse = (APIListSingleChannelResponse)mapper.readValue(jsonPayload, APIListSingleChannelResponse.class);
            builder.setApiResponse(channelsResponse);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        return builder.build();
    }
}

