/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import org.apache.http.HttpHost;
import org.apache.http.auth.Credentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProxyInfo {
    private final HttpHost proxyHost;
    private final Optional<Credentials> proxyCredentials;

    private ProxyInfo(HttpHost proxyHost, Optional<Credentials> proxyCredentials) {
        this.proxyHost = proxyHost;
        this.proxyCredentials = proxyCredentials;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<Credentials> getProxyCredentials() {
        return this.proxyCredentials;
    }

    public HttpHost getProxyHost() {
        return this.proxyHost;
    }

    public String toString() {
        return "ProxyInfo{proxyHost=" + this.proxyHost + ", proxyCredentials=" + this.proxyCredentials + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.proxyHost, this.proxyCredentials});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProxyInfo other = (ProxyInfo)obj;
        return Objects.equal((Object)this.proxyHost, (Object)other.proxyHost) && Objects.equal(this.proxyCredentials, other.proxyCredentials);
    }

    public static class Builder {
        private HttpHost proxyHost;
        private Credentials proxyCredentials;

        private Builder() {
        }

        public Builder setProxyHost(HttpHost value) {
            this.proxyHost = value;
            return this;
        }

        public Builder setProxyCredentials(Credentials value) {
            this.proxyCredentials = value;
            return this;
        }

        public ProxyInfo build() {
            return new ProxyInfo(this.proxyHost, Optional.fromNullable((Object)this.proxyCredentials));
        }
    }
}

