/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.urbanairship.api.client.APIRequestException;
import com.urbanairship.api.client.model.APIClientResponse;
import com.urbanairship.api.client.model.APIScheduleResponse;
import com.urbanairship.api.client.parse.APIResponseObjectMapper;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScheduleAPIResponseHandler
implements ResponseHandler<APIClientResponse<APIScheduleResponse>> {
    private static final ObjectMapper mapper = APIResponseObjectMapper.getInstance();
    private static final APIClientResponse.Builder<APIScheduleResponse> builder = APIClientResponse.newScheduleResponseBuilder();

    public APIClientResponse<APIScheduleResponse> handleResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        switch (statusCode) {
            case 201: {
                return this.handleSuccessfulSchedule(response);
            }
            case 400: 
            case 401: 
            case 403: {
                throw APIRequestException.exceptionForResponse(response);
            }
        }
        if (statusCode >= 200 && statusCode < 300) {
            return this.handleSuccessfulSchedule(response);
        }
        throw APIRequestException.exceptionForResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIClientResponse<APIScheduleResponse> handleSuccessfulSchedule(HttpResponse response) throws IOException {
        builder.setHttpResponse(response);
        try {
            String jsonPayload = EntityUtils.toString((HttpEntity)response.getEntity());
            APIScheduleResponse scheduleResponse = (APIScheduleResponse)mapper.readValue(jsonPayload, APIScheduleResponse.class);
            builder.setApiResponse(scheduleResponse);
        }
        finally {
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        return builder.build();
    }
}

