/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client.model;

import com.google.common.base.Objects;
import com.urbanairship.api.client.model.APIListAllChannelsResponse;
import com.urbanairship.api.client.model.APIListAllSchedulesResponse;
import com.urbanairship.api.client.model.APIListAllSegmentsResponse;
import com.urbanairship.api.client.model.APIListSingleChannelResponse;
import com.urbanairship.api.client.model.APIListTagsResponse;
import com.urbanairship.api.client.model.APILocationResponse;
import com.urbanairship.api.client.model.APIPushResponse;
import com.urbanairship.api.client.model.APIReportsPushListingResponse;
import com.urbanairship.api.client.model.APIScheduleResponse;
import com.urbanairship.api.reports.model.AppStats;
import com.urbanairship.api.reports.model.PerPushDetailResponse;
import com.urbanairship.api.reports.model.PerPushSeriesResponse;
import com.urbanairship.api.reports.model.ReportsAPIOpensResponse;
import com.urbanairship.api.reports.model.ReportsAPITimeInAppResponse;
import com.urbanairship.api.reports.model.SinglePushInfoResponse;
import com.urbanairship.api.schedule.model.SchedulePayload;
import com.urbanairship.api.segments.model.AudienceSegment;
import java.util.List;
import org.apache.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIClientResponse<T> {
    private final T apiResponse;
    private final HttpResponse httpResponse;

    private APIClientResponse(T apiResponse, HttpResponse httpResponse) {
        this.apiResponse = apiResponse;
        this.httpResponse = httpResponse;
    }

    public static Builder<APIPushResponse> newPushResponseBuilder() {
        return new Builder<APIPushResponse>();
    }

    public static Builder<APIScheduleResponse> newScheduleResponseBuilder() {
        return new Builder<APIScheduleResponse>();
    }

    public static Builder<APIListAllSchedulesResponse> newListAllSchedulesResponseBuilder() {
        return new Builder<APIListAllSchedulesResponse>();
    }

    public static Builder<SchedulePayload> newSchedulePayloadBuilder() {
        return new Builder<SchedulePayload>();
    }

    public static Builder<APIListTagsResponse> newListTagsResponseBuilder() {
        return new Builder<APIListTagsResponse>();
    }

    public static Builder<SinglePushInfoResponse> newSinglePushInfoResponseBuilder() {
        return new Builder<SinglePushInfoResponse>();
    }

    public static Builder<APIReportsPushListingResponse> newReportsListingResponseBuilder() {
        return new Builder<APIReportsPushListingResponse>();
    }

    public static Builder<List<AppStats>> newListAppStatsBuilder() {
        return new Builder<List<AppStats>>();
    }

    public static Builder<ReportsAPIOpensResponse> newAppsOpenReportResponseBuilder() {
        return new Builder<ReportsAPIOpensResponse>();
    }

    public static Builder<ReportsAPITimeInAppResponse> newTimeInAppReportResponseBuilder() {
        return new Builder<ReportsAPITimeInAppResponse>();
    }

    public static Builder<PerPushDetailResponse> newListPerPushDetailBuilder() {
        return new Builder<PerPushDetailResponse>();
    }

    public static Builder<PerPushSeriesResponse> newListPerPushSeriesBuilder() {
        return new Builder<PerPushSeriesResponse>();
    }

    public static Builder<String> newStringResponseBuilder() {
        return new Builder<String>();
    }

    public static Builder<APIListSingleChannelResponse> newSingleChannelResponseBuilder() {
        return new Builder<APIListSingleChannelResponse>();
    }

    public static Builder<APIListAllChannelsResponse> newListAllChannelsResponseBuilder() {
        return new Builder<APIListAllChannelsResponse>();
    }

    public static Builder<APIListAllSegmentsResponse> newListAllSegmentsResponseBuilder() {
        return new Builder<APIListAllSegmentsResponse>();
    }

    public static Builder<AudienceSegment> newAudienceSegmentResponseBuilder() {
        return new Builder<AudienceSegment>();
    }

    public static Builder<APILocationResponse> newLocationResponseBuilder() {
        return new Builder<APILocationResponse>();
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public T getApiResponse() {
        return this.apiResponse;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.apiResponse, this.httpResponse});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        APIClientResponse other = (APIClientResponse)obj;
        return Objects.equal(this.apiResponse, other.apiResponse) && Objects.equal((Object)this.httpResponse, (Object)other.httpResponse);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\nHttp:");
        builder.append(this.httpResponse.toString());
        builder.append("\nAPI:");
        builder.append(this.apiResponse.toString());
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T> {
        private T apiResponse;
        private HttpResponse httpResponse;

        private Builder() {
        }

        public Builder<T> setApiResponse(T apiResponse) {
            this.apiResponse = apiResponse;
            return this;
        }

        public Builder<T> setHttpResponse(HttpResponse httpResponse) {
            this.httpResponse = httpResponse;
            return this;
        }

        public APIClientResponse<T> build() {
            return new APIClientResponse(this.apiResponse, this.httpResponse);
        }
    }
}

