/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.client.model.SegmentInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APIListAllSegmentsResponse {
    private final String nextPage;
    private final ImmutableList<SegmentInformation> segments;

    private APIListAllSegmentsResponse(String nextPage, ImmutableList<SegmentInformation> segments) {
        this.nextPage = nextPage;
        this.segments = segments;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getNextPage() {
        return this.nextPage;
    }

    public ImmutableList<SegmentInformation> getSegments() {
        return this.segments;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nextPage, this.segments});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        APIListAllSegmentsResponse other = (APIListAllSegmentsResponse)obj;
        return Objects.equal((Object)this.nextPage, (Object)other.nextPage) && Objects.equal(this.segments, other.segments);
    }

    public String toString() {
        return "APIListAllSegmentsResponse{nextPage='" + this.nextPage + '\'' + ", segments=" + this.segments + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private String nextPage;
        private ImmutableList.Builder<SegmentInformation> segments = ImmutableList.builder();

        private Builder() {
        }

        public Builder setNextPage(String value) {
            this.nextPage = value;
            return this;
        }

        public Builder setSegments(Iterable<? extends SegmentInformation> value) {
            this.segments.addAll(value);
            return this;
        }

        public APIListAllSegmentsResponse build() {
            return new APIListAllSegmentsResponse(this.nextPage, this.segments.build());
        }
    }
}

