/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APIListTagsResponse {
    private final ImmutableList<String> tags;

    private APIListTagsResponse(ImmutableList<String> tags) {
        this.tags = tags;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "APIListTagResponse{tags=" + this.tags + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tags});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        APIListTagsResponse other = (APIListTagsResponse)obj;
        return Objects.equal(this.tags, other.tags);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private ImmutableList.Builder<String> tags = ImmutableList.builder();

        private Builder() {
        }

        public Builder addTag(String tag) {
            this.tags.add((Object)tag);
            return this;
        }

        public Builder allAllTags(Iterable<? extends String> tags) {
            this.tags.addAll(tags);
            return this;
        }

        public APIListTagsResponse build() {
            Preconditions.checkNotNull(this.tags);
            return new APIListTagsResponse(this.tags.build());
        }
    }
}

