/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client.model;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.location.model.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APILocationResponse {
    private final Optional<ImmutableList<Location>> features;

    private APILocationResponse(ImmutableList<Location> features) {
        this.features = Optional.fromNullable(features);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<ImmutableList<Location>> getFeatures() {
        return this.features;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.features});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        APILocationResponse other = (APILocationResponse)obj;
        return Objects.equal(this.features, other.features);
    }

    public String toString() {
        return "APILocationResponse{features=" + this.features + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private ImmutableList.Builder<Location> features = ImmutableList.builder();

        private Builder() {
        }

        public Builder addAllFeatures(Iterable<? extends Location> value) {
            this.features.addAll(value);
            return this;
        }

        public APILocationResponse build() {
            return new APILocationResponse(this.features.build());
        }
    }
}

