/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.common.parse;

import com.google.common.base.Optional;
import com.urbanairship.api.common.APIException;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.JsonLocation;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonStreamContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIParsingException
extends APIException {
    private static final Logger log = LoggerFactory.getLogger((String)"com.urbanairship.api");
    private final Optional<String> path;
    private final Optional<JsonLocation> location;

    public APIParsingException(String message, String path, JsonLocation location) {
        super(message);
        this.path = Optional.fromNullable((Object)path);
        this.location = Optional.fromNullable((Object)location);
    }

    public APIParsingException(String message) {
        super(message);
        this.path = Optional.absent();
        this.location = Optional.absent();
    }

    public APIParsingException(String message, Throwable cause) {
        super(message, cause);
        this.path = Optional.absent();
        this.location = Optional.absent();
    }

    public APIParsingException(Throwable cause) {
        super(cause);
        this.path = Optional.absent();
        this.location = Optional.absent();
    }

    @Override
    public Response.Status getStatus() {
        return Response.Status.BAD_REQUEST;
    }

    public Optional<String> getPath() {
        return this.path;
    }

    public Optional<JsonLocation> getLocation() {
        return this.location;
    }

    public static APIParsingException raise(String msg, JsonParser parser) throws APIParsingException {
        block3: {
            String message = msg;
            try {
                message = String.format("%s; at line %d, col %d, '%s'", msg, parser.getCurrentLocation().getLineNr(), parser.getCurrentLocation().getColumnNr(), APIParsingException.getPath(parser));
                if (log.isDebugEnabled()) {
                    log.debug(msg);
                }
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Exception while formatting exception.", (Throwable)ex);
            }
        }
        throw new APIParsingException(msg, APIParsingException.getPath(parser), parser.getCurrentLocation());
    }

    private static String getPath(JsonParser parser) {
        StringBuffer sb = new StringBuffer();
        JsonStreamContext context = parser.getParsingContext();
        APIParsingException.doGetPath(context, sb);
        return sb.toString();
    }

    private static void doGetPath(JsonStreamContext context, StringBuffer sb) {
        if (context.inRoot()) {
            return;
        }
        APIParsingException.doGetPath(context.getParent(), sb);
        if (context.inObject()) {
            String name = context.getCurrentName();
            if (name != null) {
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(name);
            }
        } else if (context.inArray()) {
            sb.append('[').append(context.getCurrentIndex()).append(']');
        }
    }
}

