/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.common.parse;

import com.urbanairship.api.common.parse.APIParsingException;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class BooleanFieldDeserializer {
    public static final BooleanFieldDeserializer INSTANCE = new BooleanFieldDeserializer();

    private BooleanFieldDeserializer() {
    }

    public boolean deserialize(JsonParser parser, String fieldName) throws IOException {
        JsonToken token = parser.getCurrentToken();
        if (token != JsonToken.VALUE_TRUE && token != JsonToken.VALUE_FALSE) {
            throw new APIParsingException(String.format("\"%s\" field is expected to be a boolean value (true/false).", fieldName));
        }
        return parser.getValueAsBoolean();
    }
}

