/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.common.parse;

import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.DateFormats;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeDeserializer
extends JsonDeserializer<DateTime> {
    public DateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String dateString = jp.getText();
        try {
            return DateFormats.DATE_PARSER.parseDateTime(dateString);
        }
        catch (Exception e) {
            throw new APIParsingException(String.format("Date string %s is not in accepted ISO 8601 UTC date format", dateString));
        }
    }
}

