/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.common.parse;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.FieldParser;
import com.urbanairship.api.common.parse.FieldParserRegistry;
import com.urbanairship.api.common.parse.JsonObjectReader;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardObjectDeserializer<T, R extends JsonObjectReader<T>> {
    private static final Logger log = LoggerFactory.getLogger((String)"com.urbanairship.api");
    private final FieldParserRegistry<T, R> registry;
    private final Supplier<R> readerSupplier;

    public StandardObjectDeserializer(FieldParserRegistry<T, R> registry, Supplier<R> readerSupplier) {
        this.registry = registry;
        this.readerSupplier = readerSupplier;
    }

    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken token = jp.getCurrentToken();
        if (token == JsonToken.START_OBJECT) {
            token = jp.nextToken();
        }
        JsonObjectReader reader = (JsonObjectReader)this.readerSupplier.get();
        while (token != null && token != JsonToken.END_OBJECT) {
            if (token != JsonToken.FIELD_NAME) {
                APIParsingException.raise("Parsing of json failed.  Expected to be at field name token but was " + token.name(), jp);
            }
            String name = jp.getCurrentName();
            jp.nextToken();
            Optional<FieldParser<R>> fieldParser = this.registry.getFieldParser(name);
            if (fieldParser.isPresent()) {
                ((FieldParser)fieldParser.get()).parse(reader, jp, ctxt);
            } else {
                APIParsingException.raise(String.format("The key '%s' is not allowed in this context", name), jp);
            }
            token = jp.nextToken();
        }
        return reader.validateAndBuild();
    }
}

