/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.location.parse;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.FieldParser;
import com.urbanairship.api.common.parse.FieldParserRegistry;
import com.urbanairship.api.common.parse.MapFieldParserRegistry;
import com.urbanairship.api.common.parse.StandardObjectDeserializer;
import com.urbanairship.api.location.model.Location;
import com.urbanairship.api.location.parse.LocationReader;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationDeserializer
extends JsonDeserializer<Location> {
    public static final LocationDeserializer INSTANCE = new LocationDeserializer();
    private static final FieldParserRegistry<Location, LocationReader> FIELD_PARSERS = new MapFieldParserRegistry<Location, LocationReader>((Map<String, FieldParser<LocationReader>>)ImmutableMap.builder().put((Object)"bounds", (Object)new FieldParser<LocationReader>(){

        @Override
        public void parse(LocationReader reader, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            reader.readBounds(jsonParser);
        }
    }).put((Object)"centroid", (Object)new FieldParser<LocationReader>(){

        @Override
        public void parse(LocationReader reader, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            reader.readCentroid(jsonParser);
        }
    }).put((Object)"id", (Object)new FieldParser<LocationReader>(){

        @Override
        public void parse(LocationReader reader, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            reader.readId(jsonParser);
        }
    }).put((Object)"properties", (Object)new FieldParser<LocationReader>(){

        @Override
        public void parse(LocationReader reader, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            reader.readPropertyJSONNode(jsonParser);
        }
    }).put((Object)"type", (Object)new FieldParser<LocationReader>(){

        @Override
        public void parse(LocationReader reader, JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            reader.readType(jsonParser);
        }
    }).build());
    private final StandardObjectDeserializer<Location, ?> deserializer = new StandardObjectDeserializer<Location, LocationReader>(FIELD_PARSERS, new Supplier<LocationReader>(){

        public LocationReader get() {
            return new LocationReader();
        }
    });

    public Location deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        try {
            return this.deserializer.deserialize(parser, deserializationContext);
        }
        catch (Exception e) {
            throw APIParsingException.raise(String.format("Error parsing location object. %s", e.getMessage()), parser);
        }
    }
}

