/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.actions;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.urbanairship.api.push.model.PushModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LandingPageContent
extends PushModelObject {
    private final Optional<Encoding> encoding;
    private final String body;
    private final String contentType;
    public static final int MAX_BODY_SIZE_BYTES = 524288;
    public static final int MAX_BODY_SIZE_BASE64 = LandingPageContent.byteLengthBase64Encoded(524288);
    public static final int LARGE_BODY_SIZE_BYTES = 262144;
    public static final int LARGE_BODY_SIZE_BASE64 = LandingPageContent.byteLengthBase64Encoded(262144);
    public static final ImmutableSet<String> ALLOWED_CONTENT_TYPES = ImmutableSet.of((Object)"image/jpeg", (Object)"image/png", (Object)"image/gif", (Object)"image/tiff", (Object)"text/html", (Object)"text/plain", (Object[])new String[]{"application/json", "application/x-javascript", "text/javascript", "text/x-javascript", "text/x-json", "application/vnd.ms-excel", "application/msexcel", "application/x-msexcel", "application/x-ms-excel", "application/x-excel", "application/x-dos_ms_excel", "application/xls", "application/x-xls", "application/rtf", "application/x-rtf", "text/richtext", "application/pdf", "application/msexcel", "application/mspowerpoint", "application/msword", "application/vnd.apple.keynote", "application/vnd.apple.pages", "application/vnd.apple.numbers", "application/x-iwork-keynote-sffkey", "application/x-iwork-pages-sffpages", "application/x-iwork-numbers-sffnumbers"});

    private static int byteLengthBase64Encoded(int bytes) {
        return (int)Math.ceil((double)bytes / 3.0) * 4;
    }

    private LandingPageContent(String contentType, Optional<Encoding> encoding, String body) {
        this.contentType = contentType;
        this.encoding = encoding;
        this.body = body;
    }

    public boolean requiresImageHostingEntitlement() {
        int large_size = this.encoding.isPresent() && this.encoding.get() == Encoding.Base64 ? LARGE_BODY_SIZE_BASE64 : 262144;
        return this.body.length() > large_size;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return LandingPageContent.newBuilder().mergeFrom(this);
    }

    public String getContentType() {
        return this.contentType;
    }

    public Optional<Encoding> getEncoding() {
        return this.encoding;
    }

    public String getBody() {
        return this.body;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.encoding, this.body, this.contentType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LandingPageContent other = (LandingPageContent)obj;
        return Objects.equal(this.encoding, other.encoding) && Objects.equal((Object)this.body, (Object)other.body) && Objects.equal((Object)this.contentType, (Object)other.contentType);
    }

    public String toString() {
        return "LandingPageContent{encoding=" + this.encoding + ", body='" + this.body + '\'' + ", contentType='" + this.contentType + '\'' + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        private Optional<Encoding> encoding = Optional.absent();
        private Optional<String> body = Optional.absent();
        private Optional<String> contentType = Optional.absent();

        private Builder() {
        }

        public Builder mergeFrom(LandingPageContent other) {
            this.encoding = other.getEncoding();
            return this.setBody(other.getBody()).setContentType(other.getContentType());
        }

        public Builder setEncoding(Encoding encoding) {
            this.encoding = Optional.of((Object)((Object)encoding));
            return this;
        }

        public Builder setEncoding(Optional<Encoding> encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setBody(String body) {
            this.body = Optional.of((Object)body);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.contentType = Optional.of((Object)contentType);
            return this;
        }

        public LandingPageContent build() {
            if (!this.body.isPresent()) {
                throw new RuntimeException("Content needs a body.");
            }
            if (!this.contentType.isPresent()) {
                throw new RuntimeException("Content needs contentType.");
            }
            Preconditions.checkNotNull(this.encoding, (Object)"encoding should not be null.");
            return new LandingPageContent((String)this.contentType.get(), this.encoding, (String)this.body.get());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Encoding {
        UTF8,
        Base64;

    }
}

