/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.blackberry;

import com.google.common.base.Optional;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BlackberryDevicePayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<String> alert;
    private final Optional<String> body;
    private final Optional<String> contentType;

    private BlackberryDevicePayload(Optional<String> alert, Optional<String> body, Optional<String> contentType) {
        this.alert = alert;
        this.body = body;
        this.contentType = contentType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.BLACKBERRY;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert;
    }

    public Optional<String> getBody() {
        return this.body;
    }

    public Optional<String> getContentType() {
        return this.contentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlackberryDevicePayload that = (BlackberryDevicePayload)o;
        if (this.alert != null ? !this.alert.equals(that.alert) : that.alert != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        return !(this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null);
    }

    public int hashCode() {
        int result = this.alert != null ? this.alert.hashCode() : 0;
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String alert = null;
        private String body = null;
        private String contentType = null;

        private Builder() {
        }

        public Builder setAlert(String value) {
            this.alert = value;
            return this;
        }

        public Builder setBody(String value) {
            this.body = value;
            return this;
        }

        public Builder setContentType(String value) {
            this.contentType = value;
            return this;
        }

        public BlackberryDevicePayload build() {
            return new BlackberryDevicePayload(Optional.fromNullable((Object)this.alert), Optional.fromNullable((Object)this.body), Optional.fromNullable((Object)this.contentType));
        }
    }
}

