/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.ios;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.Interactive;
import com.urbanairship.api.push.model.notification.ios.IOSAlertData;
import com.urbanairship.api.push.model.notification.ios.IOSBadgeData;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IOSDevicePayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<IOSAlertData> alert;
    private final Optional<ImmutableMap<String, String>> extra;
    private final Optional<String> sound;
    private final Optional<IOSBadgeData> badge;
    private final Optional<Boolean> contentAvailable;
    private final Optional<PushExpiry> expiry;
    private final Optional<Integer> priority;
    private final Optional<String> category;
    private final Optional<Interactive> interactive;

    private IOSDevicePayload(Optional<IOSAlertData> alert, Optional<String> sound, Optional<IOSBadgeData> badge, Optional<Boolean> contentAvailable, Optional<PushExpiry> expiry, Optional<Integer> priority, Optional<ImmutableMap<String, String>> extra, Optional<String> category, Optional<Interactive> interactive) {
        this.alert = alert;
        this.sound = sound;
        this.badge = badge;
        this.contentAvailable = contentAvailable;
        this.extra = extra;
        this.expiry = expiry;
        this.priority = priority;
        this.category = category;
        this.interactive = interactive;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.IOS;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert.isPresent() ? ((IOSAlertData)this.alert.get()).getBody() : Optional.absent();
    }

    public Optional<IOSAlertData> getAlertData() {
        return this.alert;
    }

    public Optional<String> getSound() {
        return this.sound;
    }

    public Optional<IOSBadgeData> getBadge() {
        return this.badge;
    }

    public Optional<Boolean> getContentAvailable() {
        return this.contentAvailable;
    }

    public Optional<ImmutableMap<String, String>> getExtra() {
        return this.extra;
    }

    public Optional<PushExpiry> getExpiry() {
        return this.expiry;
    }

    public Optional<Integer> getPriority() {
        return this.priority;
    }

    public Optional<String> getCategory() {
        return this.category;
    }

    public Optional<Interactive> getInteractive() {
        return this.interactive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOSDevicePayload that = (IOSDevicePayload)o;
        if (this.alert != null ? !this.alert.equals(that.alert) : that.alert != null) {
            return false;
        }
        if (this.extra != null ? !this.extra.equals(that.extra) : that.extra != null) {
            return false;
        }
        if (this.sound != null ? !this.sound.equals(that.sound) : that.sound != null) {
            return false;
        }
        if (this.badge != null ? !this.badge.equals(that.badge) : that.badge != null) {
            return false;
        }
        if (this.contentAvailable != null ? !this.contentAvailable.equals(that.contentAvailable) : that.contentAvailable != null) {
            return false;
        }
        if (this.expiry != null ? !this.expiry.equals(that.expiry) : that.expiry != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        if (this.category != null ? !this.category.equals(that.category) : that.category != null) {
            return false;
        }
        return !(this.interactive != null ? !this.interactive.equals(that.interactive) : that.interactive != null);
    }

    public int hashCode() {
        int result = this.alert != null ? this.alert.hashCode() : 0;
        result = 31 * result + (this.extra != null ? this.extra.hashCode() : 0);
        result = 31 * result + (this.sound != null ? this.sound.hashCode() : 0);
        result = 31 * result + (this.badge != null ? this.badge.hashCode() : 0);
        result = 31 * result + (this.contentAvailable != null ? this.contentAvailable.hashCode() : 0);
        result = 31 * result + (this.expiry != null ? this.expiry.hashCode() : 0);
        result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        result = 31 * result + (this.interactive != null ? this.interactive.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "IOSDevicePayload{alert=" + this.alert + ", extra=" + this.extra + ", sound=" + this.sound + ", badge=" + this.badge + ", expiry=" + this.expiry + ", priority" + this.priority + ", contentAvailable=" + this.contentAvailable + ", category=" + this.category + ", interactive=" + this.interactive + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private IOSAlertData alert = null;
        private String sound = null;
        private IOSBadgeData badge = null;
        private Boolean contentAvailable = null;
        private ImmutableMap.Builder<String, String> extra = null;
        private PushExpiry expiry = null;
        private Integer priority = null;
        private String category = null;
        private Interactive interactive = null;

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alert = IOSAlertData.newBuilder().setBody(alert).build();
            return this;
        }

        public Builder setAlert(IOSAlertData alert) {
            this.alert = alert;
            return this;
        }

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder setBadge(IOSBadgeData badge) {
            this.badge = badge;
            return this;
        }

        public Builder setContentAvailable(boolean value) {
            this.contentAvailable = value;
            return this;
        }

        public Builder setExpiry(PushExpiry value) {
            this.expiry = value;
            return this;
        }

        public Builder setPriority(int value) {
            this.priority = value;
            return this;
        }

        public Builder addExtraEntry(String key, String value) {
            if (this.extra == null) {
                this.extra = ImmutableMap.builder();
            }
            this.extra.put((Object)key, (Object)value);
            return this;
        }

        public Builder addAllExtraEntries(Map<String, String> entries) {
            if (this.extra == null) {
                this.extra = ImmutableMap.builder();
            }
            this.extra.putAll(entries);
            return this;
        }

        public Builder setCategory(String value) {
            this.category = value;
            return this;
        }

        public Builder setInteractive(Interactive value) {
            this.interactive = value;
            return this;
        }

        public IOSDevicePayload build() {
            return new IOSDevicePayload(Optional.fromNullable((Object)this.alert), Optional.fromNullable((Object)this.sound), Optional.fromNullable((Object)this.badge), Optional.fromNullable((Object)this.contentAvailable), Optional.fromNullable((Object)this.expiry), Optional.fromNullable((Object)this.priority), this.extra == null ? Optional.absent() : Optional.fromNullable((Object)this.extra.build()), Optional.fromNullable((Object)this.category), Optional.fromNullable((Object)this.interactive));
        }
    }
}

