/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.mpns;

import com.google.common.base.Optional;
import com.urbanairship.api.push.model.DeviceType;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.DevicePayloadOverride;
import com.urbanairship.api.push.model.notification.mpns.MPNSPush;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MPNSDevicePayload
extends PushModelObject
implements DevicePayloadOverride {
    private final Optional<MPNSPush> body;
    private final Optional<String> alert;

    private MPNSDevicePayload(Optional<MPNSPush> body, Optional<String> alert) {
        this.body = body;
        this.alert = alert;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.MPNS;
    }

    @Override
    public Optional<String> getAlert() {
        return this.alert;
    }

    public MPNSPush.Type getType() {
        if (this.body.isPresent()) {
            return ((MPNSPush)this.body.get()).getType();
        }
        return MPNSPush.Type.TOAST;
    }

    public Optional<MPNSPush> getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MPNSDevicePayload that = (MPNSDevicePayload)o;
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        return !(this.alert != null ? !this.alert.equals(that.alert) : that.alert != null);
    }

    public int hashCode() {
        int result = this.body != null ? this.body.hashCode() : 0;
        result = 31 * result + (this.alert != null ? this.alert.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String alert;
        private MPNSPush body;

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder setBody(MPNSPush body) {
            this.body = body;
            return this;
        }

        public MPNSDevicePayload build() {
            return new MPNSDevicePayload(Optional.fromNullable((Object)this.body), Optional.fromNullable((Object)this.alert));
        }
    }
}

