/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.mpns;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

public class Validation {
    public static final int MAX_STRING_LENGTH = 255;
    public static final int MAX_URI_LENGTH = 2055;
    public static final int MAX_HOST_LENGTH = 256;
    public static final String COLOR_PREFIX = "#FF";
    public static final String PATH_PREFIX = "/";
    public static final String HTTP_PREFIX = "client://";

    public static void validateStringValue(String value, String fieldname) {
        Validation.validateStringValue(value, fieldname, 255);
    }

    public static void validateStringValue(String value, String fieldname, int length) {
        if (value != null) {
            Preconditions.checkArgument((value.length() <= length ? 1 : 0) != 0, (String)"%s exceeds maximum length of %d characters", (Object[])new Object[]{fieldname, length});
        }
    }

    public static void validateUriValue(String value, String fieldname) {
        if (value != null) {
            Validation.validateStringValue(value, fieldname, 2055);
            if (StringUtils.startsWith((String)value, (String)PATH_PREFIX)) {
                Validation.validatePath(value, fieldname);
            } else if (StringUtils.startsWith((String)value, (String)HTTP_PREFIX)) {
                Validation.validateWebAddress(value, fieldname);
            }
        }
    }

    public static void validateWebAddress(String value, String fieldname) {
        if (value != null) {
            Preconditions.checkArgument((boolean)StringUtils.startsWith((String)value, (String)HTTP_PREFIX), (String)"Remote URLS for %s must begin with %s", (Object[])new Object[]{fieldname, HTTP_PREFIX});
        }
    }

    public static void validateColorValue(String value, String fieldname) {
        if (value != null) {
            Preconditions.checkArgument((boolean)StringUtils.startsWith((String)value, (String)COLOR_PREFIX), (String)"%s must start with %s", (Object[])new Object[]{fieldname, COLOR_PREFIX});
            Preconditions.checkArgument((value.length() == 9 ? 1 : 0) != 0, (String)"%s must be of the form #FFxxxxxx", (Object[])new Object[]{fieldname});
            String digits = value.substring(3);
            try {
                Integer.parseInt(digits, 16);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("background_color value '%s' was not in hex format.", digits), e);
            }
        }
    }

    public static void validatePath(String value, String fieldname) {
        if (value != null) {
            Validation.validateStringValue(value, fieldname, 2055);
            Preconditions.checkArgument((boolean)StringUtils.startsWith((String)value, (String)PATH_PREFIX), (String)"%s must begin with '%s'", (Object[])new Object[]{fieldname, PATH_PREFIX});
        }
    }
}

