/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.audience.location;

import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.BooleanFieldDeserializer;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.push.model.audience.location.AbsoluteDateRange;
import com.urbanairship.api.push.model.audience.location.DateRange;
import com.urbanairship.api.push.model.audience.location.DateRangeUnit;
import com.urbanairship.api.push.model.audience.location.PresenceTimeframe;
import com.urbanairship.api.push.model.audience.location.RecentDateRange;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateRangeReader
implements JsonObjectReader<DateRange> {
    private PresenceTimeframe timeframe = PresenceTimeframe.ANYTIME;
    private AbsoluteDateRange.Builder absoluteBuilder = null;
    private RecentDateRange.Builder recentBuilder = null;

    public void readTimeframe(JsonParser parser) throws IOException {
        boolean value = BooleanFieldDeserializer.INSTANCE.deserialize(parser, "last_seen");
        if (value) {
            this.timeframe = PresenceTimeframe.LAST_SEEN;
        }
    }

    public void readAbsolute(JsonParser parser) throws IOException {
        this.absoluteBuilder = (AbsoluteDateRange.Builder)parser.readValueAs(AbsoluteDateRange.Builder.class);
    }

    public void setResolution(DateRangeUnit resolution) {
        if (this.absoluteBuilder != null) {
            this.absoluteBuilder.setResolution(resolution);
        } else if (this.recentBuilder != null) {
            this.recentBuilder.setResolution(resolution);
        }
    }

    public void readRecent(JsonParser parser) throws IOException {
        this.recentBuilder = (RecentDateRange.Builder)parser.readValueAs(RecentDateRange.Builder.class);
    }

    @Override
    public DateRange validateAndBuild() throws IOException {
        try {
            if (this.absoluteBuilder == null && this.recentBuilder == null) {
                throw new APIParsingException("Must supply one of 'days' or 'recent' date specifier for location expression");
            }
            if (this.absoluteBuilder != null && this.recentBuilder != null) {
                throw new APIParsingException("Must supply only one of 'days' or 'recent' date specifier for location expression");
            }
            if (this.absoluteBuilder != null) {
                this.absoluteBuilder.setTimeframe(this.timeframe);
                return this.absoluteBuilder.build();
            }
            this.recentBuilder.setTimeframe(this.timeframe);
            return this.recentBuilder.build();
        }
        catch (APIParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage(), (Throwable)e);
        }
    }
}

