/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.audience.location;

import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.IntFieldDeserializer;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.push.model.audience.location.DateRangeUnit;
import com.urbanairship.api.push.model.audience.location.RecentDateRange;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentDateRangeReader
implements JsonObjectReader<RecentDateRange.Builder> {
    private RecentDateRange.Builder builder = null;

    public void readValue(JsonParser parser) throws IOException {
        if (this.builder == null) {
            this.builder = RecentDateRange.newBuilder();
        } else if (this.builder != null) {
            APIParsingException.raise("Only one date range is allowed on 'recent'", parser);
        }
        String type = parser.getCurrentName();
        DateRangeUnit unit = DateRangeUnit.getUnitForIdentifier(type);
        if (unit == null) {
            APIParsingException.raise(String.format("Unknown date range unit '%s'", type), parser);
        }
        int value = IntFieldDeserializer.INSTANCE.deserialize(parser, type);
        this.builder.setResolution(unit).setUnits(value);
    }

    @Override
    public RecentDateRange.Builder validateAndBuild() throws IOException {
        return this.builder;
    }
}

