/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.push.model.notification.actions.TagActionData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TagActionDataDeserializer
extends JsonDeserializer<TagActionData> {
    public TagActionData deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode jsonNode = parser.readValueAsTree();
        if (!jsonNode.isArray() && !jsonNode.isTextual()) {
            throw new APIParsingException("Tag must be a string or an array.");
        }
        if (jsonNode.isTextual()) {
            return TagActionData.single(jsonNode.getTextValue());
        }
        Iterator items = jsonNode.getElements();
        ArrayList tags = Lists.newArrayList();
        while (items.hasNext()) {
            JsonNode item = (JsonNode)items.next();
            if (item.isNull() || !item.isTextual()) {
                throw new APIParsingException("Null or non-string tags are not allowed.");
            }
            tags.add(item.getTextValue());
        }
        if (tags.size() == 0) {
            throw new APIParsingException("Tag list must contain at least one tag.");
        }
        return TagActionData.set(Sets.newHashSet((Iterable)tags));
    }
}

