/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.ios;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.FieldParser;
import com.urbanairship.api.common.parse.FieldParserRegistry;
import com.urbanairship.api.common.parse.MapFieldParserRegistry;
import com.urbanairship.api.common.parse.StandardObjectDeserializer;
import com.urbanairship.api.push.model.notification.ios.IOSAlertData;
import com.urbanairship.api.push.parse.notification.ios.IOSAlertDataReader;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOSAlertDataDeserializer
extends JsonDeserializer<IOSAlertData> {
    private static final FieldParserRegistry<IOSAlertData, IOSAlertDataReader> FIELD_PARSERS = new MapFieldParserRegistry<IOSAlertData, IOSAlertDataReader>((Map<String, FieldParser<IOSAlertDataReader>>)ImmutableMap.builder().put((Object)"body", (Object)new FieldParser<IOSAlertDataReader>(){

        @Override
        public void parse(IOSAlertDataReader reader, JsonParser json, DeserializationContext context) throws IOException {
            reader.readBody(json, context);
        }
    }).put((Object)"action-loc-key", (Object)new FieldParser<IOSAlertDataReader>(){

        @Override
        public void parse(IOSAlertDataReader reader, JsonParser json, DeserializationContext context) throws IOException {
            reader.readActionLocKey(json, context);
        }
    }).put((Object)"loc-key", (Object)new FieldParser<IOSAlertDataReader>(){

        @Override
        public void parse(IOSAlertDataReader reader, JsonParser json, DeserializationContext context) throws IOException {
            reader.readLocKey(json, context);
        }
    }).put((Object)"loc-args", (Object)new FieldParser<IOSAlertDataReader>(){

        @Override
        public void parse(IOSAlertDataReader reader, JsonParser json, DeserializationContext context) throws IOException {
            reader.readLocArgs(json, context);
        }
    }).put((Object)"launch-image", (Object)new FieldParser<IOSAlertDataReader>(){

        @Override
        public void parse(IOSAlertDataReader reader, JsonParser json, DeserializationContext context) throws IOException {
            reader.readLaunchImage(json, context);
        }
    }).build());
    private final StandardObjectDeserializer<IOSAlertData, ?> deserializer = new StandardObjectDeserializer<IOSAlertData, IOSAlertDataReader>(FIELD_PARSERS, new Supplier<IOSAlertDataReader>(){

        public IOSAlertDataReader get() {
            return new IOSAlertDataReader();
        }
    });

    public IOSAlertData deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        try {
            JsonToken token = parser.getCurrentToken();
            switch (token) {
                case VALUE_STRING: {
                    String alert = parser.getText();
                    return IOSAlertData.newBuilder().setBody(alert).build();
                }
                case START_OBJECT: {
                    return this.deserializer.deserialize(parser, context);
                }
            }
            APIParsingException.raise(String.format("Unexpected alert token '%s'", token.name()), parser);
        }
        catch (APIParsingException e) {
            throw e;
        }
        catch (Exception e) {
            APIParsingException.raise(e.getMessage(), parser);
        }
        return null;
    }
}

