/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.mpns;

import com.google.common.base.Optional;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import com.urbanairship.api.push.model.notification.mpns.MPNSDevicePayload;
import com.urbanairship.api.push.model.notification.mpns.MPNSPush;
import com.urbanairship.api.push.parse.notification.mpns.MPNSBatchingIntervalDeserializer;
import com.urbanairship.api.push.parse.notification.mpns.MPNSTileDeserializer;
import com.urbanairship.api.push.parse.notification.mpns.MPNSToastDeserializer;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPNSDevicePayloadReader
implements JsonObjectReader<MPNSDevicePayload> {
    private MPNSPush.Builder builder;
    private final MPNSToastDeserializer toastDS;
    private final MPNSTileDeserializer tileDS;
    private Optional<String> alert = Optional.absent();

    public MPNSDevicePayloadReader(MPNSToastDeserializer toastDS, MPNSTileDeserializer tileDS) {
        this.toastDS = toastDS;
        this.tileDS = tileDS;
    }

    public void readAlert(JsonParser parser, DeserializationContext context) throws IOException {
        this.alert = Optional.fromNullable((Object)StringFieldDeserializer.INSTANCE.deserialize(parser, "alert"));
    }

    public void readToast(JsonParser parser, DeserializationContext context) throws IOException {
        if (this.builder == null) {
            this.builder = MPNSPush.newBuilder();
        }
        this.builder.setToast(this.toastDS.deserialize(parser, context));
        this.builder.setType(MPNSPush.Type.TOAST);
    }

    public void readTile(JsonParser parser, DeserializationContext context) throws IOException {
        if (this.builder == null) {
            this.builder = MPNSPush.newBuilder();
        }
        this.builder.setTile(this.tileDS.deserialize(parser, context));
        this.builder.setType(MPNSPush.Type.TILE);
    }

    public void readBatchingInterval(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.setBatchingInterval(MPNSBatchingIntervalDeserializer.INSTANCE.deserialize(parser, context));
    }

    @Override
    public MPNSDevicePayload validateAndBuild() throws IOException {
        try {
            if (!this.alert.isPresent() && this.builder == null) {
                throw new APIParsingException("'mpns' override cannot be empty.");
            }
            if (this.alert.isPresent() && this.builder != null) {
                throw new APIParsingException("'mpns' override must provide exactly one of 'alert', 'tile', or 'toast'.");
            }
            MPNSPush push = null;
            if (this.builder != null) {
                push = this.builder.build();
            }
            return MPNSDevicePayload.newBuilder().setBody(push).setAlert(this.alert.isPresent() ? (String)this.alert.get() : null).build();
        }
        catch (RuntimeException e) {
            throw new APIParsingException(e.getMessage(), (Throwable)e);
        }
    }
}

