/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.mpns;

import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.IntFieldDeserializer;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.ListOfStringsDeserializer;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import com.urbanairship.api.push.model.notification.mpns.MPNSCycleTileData;
import com.urbanairship.api.push.model.notification.mpns.MPNSFlipTileData;
import com.urbanairship.api.push.model.notification.mpns.MPNSIconicTileData;
import com.urbanairship.api.push.model.notification.mpns.MPNSTileData;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPNSTileReader
implements JsonObjectReader<MPNSTileData> {
    private final MPNSCycleTileData.Builder cycleBuilder = MPNSCycleTileData.newBuilder();
    private final MPNSFlipTileData.Builder flipBuilder = MPNSFlipTileData.newBuilder();
    private final MPNSIconicTileData.Builder iconicBuilder = MPNSIconicTileData.newBuilder();
    private String template;

    public void readId(JsonParser parser) throws IOException {
        String id = StringFieldDeserializer.INSTANCE.deserialize(parser, "id");
        this.cycleBuilder.setId(id);
        this.flipBuilder.setId(id);
        this.iconicBuilder.setId(id);
    }

    public void readTitle(JsonParser parser) throws IOException {
        String title = StringFieldDeserializer.INSTANCE.deserialize(parser, "title");
        this.cycleBuilder.setTitle(title);
        this.flipBuilder.setTitle(title);
        this.iconicBuilder.setTitle(title);
    }

    public void readCount(JsonParser parser) throws IOException {
        int count = IntFieldDeserializer.INSTANCE.deserialize(parser, "count");
        this.cycleBuilder.setCount(count);
        this.flipBuilder.setCount(count);
        this.iconicBuilder.setCount(count);
    }

    public void readSmallBackgroundImage(JsonParser parser) throws IOException {
        String image = StringFieldDeserializer.INSTANCE.deserialize(parser, "small_background_image");
        this.flipBuilder.setSmallBackgroundImage(image);
        this.cycleBuilder.setSmallBackgroundImage(image);
    }

    public void readTemplate(JsonParser parser) throws IOException {
        this.template = StringFieldDeserializer.INSTANCE.deserialize(parser, "template");
    }

    public void readBackContent(JsonParser parser) throws IOException {
        this.flipBuilder.setBackContent(StringFieldDeserializer.INSTANCE.deserialize(parser, "back_content"));
    }

    public void readBackBackgroundImage(JsonParser parser) throws IOException {
        this.flipBuilder.setBackBackgroundImage(StringFieldDeserializer.INSTANCE.deserialize(parser, "back_background_image"));
    }

    public void readBackgroundImage(JsonParser parser) throws IOException {
        this.flipBuilder.setBackgroundImage(StringFieldDeserializer.INSTANCE.deserialize(parser, "background_image"));
    }

    public void readBackTitle(JsonParser parser) throws IOException {
        this.flipBuilder.setBackTitle(StringFieldDeserializer.INSTANCE.deserialize(parser, "back_title"));
    }

    public void readWideBackgroundImage(JsonParser parser) throws IOException {
        this.flipBuilder.setWideBackgroundImage(StringFieldDeserializer.INSTANCE.deserialize(parser, "wide_background_image"));
    }

    public void readWideBackBackgroundImage(JsonParser parser) throws IOException {
        this.flipBuilder.setWideBackBackgroundImage(StringFieldDeserializer.INSTANCE.deserialize(parser, "wide_back_background_image"));
    }

    public void readWideBackContent(JsonParser parser) throws IOException {
        this.flipBuilder.setWideBackContent(StringFieldDeserializer.INSTANCE.deserialize(parser, "wide_back_content"));
    }

    public void readIconImage(JsonParser parser) throws IOException {
        this.iconicBuilder.setIconImage(StringFieldDeserializer.INSTANCE.deserialize(parser, "icon_image"));
    }

    public void readSmallIconImage(JsonParser parser) throws IOException {
        this.iconicBuilder.setSmallIconImage(StringFieldDeserializer.INSTANCE.deserialize(parser, "small_icon_image"));
    }

    public void readBackgroundColor(JsonParser parser) throws IOException {
        this.iconicBuilder.setBackgroundColor(StringFieldDeserializer.INSTANCE.deserialize(parser, "background_color"));
    }

    public void readWideContent1(JsonParser parser) throws IOException {
        this.iconicBuilder.setWideContent1(StringFieldDeserializer.INSTANCE.deserialize(parser, "wide_content_1"));
    }

    public void readWideContent2(JsonParser parser) throws IOException {
        this.iconicBuilder.setWideContent2(StringFieldDeserializer.INSTANCE.deserialize(parser, "wide_content_2"));
    }

    public void readWideContent3(JsonParser parser) throws IOException {
        this.iconicBuilder.setWideContent3(StringFieldDeserializer.INSTANCE.deserialize(parser, "wide_content_3"));
    }

    public void readCycleImage(JsonParser parser) throws IOException {
        this.cycleBuilder.addAllImages(ListOfStringsDeserializer.INSTANCE.deserialize(parser, "cycle_image"));
    }

    @Override
    public MPNSTileData validateAndBuild() throws IOException {
        try {
            if (this.template.equals("CycleTile")) {
                return this.cycleBuilder.build();
            }
            if (this.template.equals("FlipTile")) {
                return this.flipBuilder.build();
            }
            if (this.template.equals("IconicTile")) {
                return this.iconicBuilder.build();
            }
            throw new APIParsingException(String.format("Invalid tile template '%s'", this.template));
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage(), (Throwable)e);
        }
    }
}

