/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.wns;

import com.google.common.base.Optional;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import com.urbanairship.api.push.model.notification.wns.WNSDevicePayload;
import com.urbanairship.api.push.model.notification.wns.WNSPush;
import com.urbanairship.api.push.parse.notification.wns.WNSBadgeDeserializer;
import com.urbanairship.api.push.parse.notification.wns.WNSCachePolicyDeserializer;
import com.urbanairship.api.push.parse.notification.wns.WNSTileDeserializer;
import com.urbanairship.api.push.parse.notification.wns.WNSToastDeserializer;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WNSDevicePayloadReader
implements JsonObjectReader<WNSDevicePayload> {
    private final WNSToastDeserializer toastDS;
    private final WNSTileDeserializer tileDS;
    private final WNSBadgeDeserializer badgeDS;
    private WNSPush.Builder builder;
    private Optional<String> alert = Optional.absent();

    public WNSDevicePayloadReader(WNSToastDeserializer toastDS, WNSTileDeserializer tileDS, WNSBadgeDeserializer badgeDS) {
        this.toastDS = toastDS;
        this.tileDS = tileDS;
        this.badgeDS = badgeDS;
    }

    public void readAlert(JsonParser parser, DeserializationContext context) throws IOException {
        this.alert = Optional.fromNullable((Object)StringFieldDeserializer.INSTANCE.deserialize(parser, "alert"));
    }

    public void readToast(JsonParser parser, DeserializationContext context) throws IOException {
        if (this.builder == null) {
            this.builder = WNSPush.newBuilder();
        }
        this.builder.setToast(this.toastDS.deserialize(parser, context));
        this.builder.setType(WNSPush.Type.TOAST);
    }

    public void readTile(JsonParser parser, DeserializationContext context) throws IOException {
        if (this.builder == null) {
            this.builder = WNSPush.newBuilder();
        }
        this.builder.setTile(this.tileDS.deserialize(parser, context));
        this.builder.setType(WNSPush.Type.TILE);
    }

    public void readBadge(JsonParser parser, DeserializationContext context) throws IOException {
        if (this.builder == null) {
            this.builder = WNSPush.newBuilder();
        }
        this.builder.setBadge(this.badgeDS.deserialize(parser, context));
        this.builder.setType(WNSPush.Type.BADGE);
    }

    public void readCachePolicy(JsonParser parser, DeserializationContext context) throws IOException {
        if (this.builder == null) {
            this.builder = WNSPush.newBuilder();
        }
        this.builder.setCachePolicy(WNSCachePolicyDeserializer.INSTANCE.deserialize(parser, context));
    }

    @Override
    public WNSDevicePayload validateAndBuild() throws IOException {
        try {
            if (!this.alert.isPresent() && this.builder == null) {
                throw new APIParsingException("'wns' override cannot be empty.");
            }
            if (this.alert.isPresent() && this.builder != null) {
                throw new APIParsingException("'wns' override must provide exactly one of 'alert', 'tile', 'toast', or 'badge'.");
            }
            WNSPush push = null;
            if (this.builder != null) {
                push = this.builder.build();
            }
            return WNSDevicePayload.newBuilder().setBody(push).setAlert(this.alert.isPresent() ? (String)this.alert.get() : null).build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage(), (Throwable)e);
        }
    }
}

