/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.wns;

import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.push.model.notification.wns.WNSToastData;
import com.urbanairship.api.push.parse.notification.wns.WNSAudioDeserializer;
import com.urbanairship.api.push.parse.notification.wns.WNSBindingDeserializer;
import com.urbanairship.api.push.parse.notification.wns.WNSDurationDeserializer;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WNSToastReader
implements JsonObjectReader<WNSToastData> {
    private final WNSToastData.Builder builder = WNSToastData.newBuilder();
    private final WNSBindingDeserializer bindingDS;
    private final WNSAudioDeserializer audioDS;

    public WNSToastReader(WNSBindingDeserializer bindingDS, WNSAudioDeserializer audioDS) {
        this.bindingDS = bindingDS;
        this.audioDS = audioDS;
    }

    public void readBinding(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.setBinding(this.bindingDS.deserialize(parser, context));
    }

    public void readDuration(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.setDuration(WNSDurationDeserializer.INSTANCE.deserialize(parser, context));
    }

    public void readAudio(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.setAudio(this.audioDS.deserialize(parser, context));
    }

    @Override
    public WNSToastData validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException("Toast must contain a valid binding.");
        }
    }
}

