/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.base.Objects;
import com.urbanairship.api.reports.model.PlatformCounts;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PerPushSeriesResponse {
    private final String appKey;
    private final UUID pushID;
    private final DateTime start;
    private final DateTime end;
    private final String precision;
    private final List<PlatformCounts> counts;

    private PerPushSeriesResponse(String appKey, UUID pushID, DateTime start, DateTime end, String precision, List<PlatformCounts> counts) {
        this.appKey = appKey;
        this.pushID = pushID;
        this.start = start;
        this.end = end;
        this.precision = precision;
        this.counts = counts;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getAppKey() {
        return this.appKey;
    }

    public UUID getPushID() {
        return this.pushID;
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public String getPrecision() {
        return this.precision;
    }

    public List<PlatformCounts> getCounts() {
        return this.counts;
    }

    public String toString() {
        return "PerPushSeriesResponse{appKey='" + this.appKey + '\'' + ", pushID=" + this.pushID + ", start=" + this.start + ", end=" + this.end + ", precision='" + this.precision + '\'' + ", counts=" + this.counts + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.appKey, this.pushID, this.start, this.end, this.precision, this.counts});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PerPushSeriesResponse other = (PerPushSeriesResponse)obj;
        return Objects.equal((Object)this.appKey, (Object)other.appKey) && Objects.equal((Object)this.pushID, (Object)other.pushID) && Objects.equal((Object)this.start, (Object)other.start) && Objects.equal((Object)this.end, (Object)other.end) && Objects.equal((Object)this.precision, (Object)other.precision) && Objects.equal(this.counts, other.counts);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private String appKey;
        private UUID pushID;
        private DateTime start;
        private DateTime end;
        private String precision;
        private List<PlatformCounts> counts = new ArrayList<PlatformCounts>();

        private Builder() {
        }

        public Builder setAppKey(String value) {
            this.appKey = value;
            return this;
        }

        public Builder setPushID(UUID value) {
            this.pushID = value;
            return this;
        }

        public Builder setStart(DateTime value) {
            this.start = value;
            return this;
        }

        public Builder setEnd(DateTime value) {
            this.end = value;
            return this;
        }

        public Builder setPrecision(String value) {
            this.precision = value;
            return this;
        }

        public Builder addPlatformCount(PlatformCounts value) {
            this.counts.add(value);
            return this;
        }

        public Builder addAllPlatformCounts(List<PlatformCounts> value) {
            this.counts.addAll(value);
            return this;
        }

        public PerPushSeriesResponse build() {
            return new PerPushSeriesResponse(this.appKey, this.pushID, this.start, this.end, this.precision, this.counts);
        }
    }
}

