/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class RichPerPushCounts {
    private long responses;
    private long sends;

    private RichPerPushCounts(long responses, long sends) {
        this.responses = responses;
        this.sends = sends;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getResponses() {
        return this.responses;
    }

    public long getSends() {
        return this.sends;
    }

    public String toString() {
        return "RichPerPushCounts{responses=" + this.responses + ", sends=" + this.sends + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.responses, this.sends});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RichPerPushCounts other = (RichPerPushCounts)obj;
        return Objects.equal((Object)this.responses, (Object)other.responses) && Objects.equal((Object)this.sends, (Object)other.sends);
    }

    public static class Builder {
        private long responses;
        private long sends;

        private Builder() {
        }

        public Builder setResponses(long value) {
            this.responses = value;
            return this;
        }

        public Builder setSends(long value) {
            this.sends = value;
            return this;
        }

        public RichPerPushCounts build() {
            Preconditions.checkNotNull((Object)this.responses, (Object)"Counts cannot be null");
            Preconditions.checkNotNull((Object)this.sends, (Object)"Counts cannot be null");
            return new RichPerPushCounts(this.responses, this.sends);
        }
    }
}

