/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.parse;

import com.google.common.base.Optional;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.reports.Base64ByteArray;
import com.urbanairship.api.reports.model.PerPushCounts;
import com.urbanairship.api.reports.model.PerPushDetailResponse;
import com.urbanairship.api.reports.model.PlatformType;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.type.TypeReference;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerPushDetailResponseReader
implements JsonObjectReader<PerPushDetailResponse> {
    private final PerPushDetailResponse.Builder builder = PerPushDetailResponse.newBuilder();

    public void readAppKey(JsonParser jsonParser) throws IOException {
        this.builder.setAppKey((String)jsonParser.readValueAs(String.class));
    }

    public void readPushID(JsonParser jsonParser) throws IOException {
        this.builder.setPushID((UUID)jsonParser.readValueAs(UUID.class));
    }

    public void readCreated(JsonParser jsonParser) throws IOException {
        String created = (String)jsonParser.readValueAs(String.class);
        if (created.equals("0")) {
            this.builder.setCreated((Optional<DateTime>)Optional.absent());
        } else {
            this.builder.setCreated((Optional<DateTime>)Optional.of((Object)DateFormats.DATE_PARSER.parseDateTime(created)));
        }
    }

    public void readPushBody(JsonParser jsonParser) throws IOException {
        String pushBody = (String)jsonParser.readValueAs(String.class);
        if (pushBody == null) {
            this.builder.setPushBody((Optional<Base64ByteArray>)Optional.absent());
        } else {
            this.builder.setPushBody((Optional<Base64ByteArray>)Optional.fromNullable((Object)new Base64ByteArray(pushBody)));
        }
    }

    public void readRichDeletions(JsonParser jsonParser) throws IOException {
        this.builder.setRichDeletions((Long)jsonParser.readValueAs(Long.TYPE));
    }

    public void readRichResponses(JsonParser jsonParser) throws IOException {
        this.builder.setRichResponses((Long)jsonParser.readValueAs(Long.TYPE));
    }

    public void readRichSends(JsonParser jsonParser) throws IOException {
        this.builder.setRichSends((Long)jsonParser.readValueAs(Long.TYPE));
    }

    public void readSends(JsonParser jsonParser) throws IOException {
        this.builder.setSends((Long)jsonParser.readValueAs(Long.TYPE));
    }

    public void readDirectResponses(JsonParser jsonParser) throws IOException {
        this.builder.setDirectResponses((Long)jsonParser.readValueAs(Long.TYPE));
    }

    public void readInfluencedResponses(JsonParser jsonParser) throws IOException {
        this.builder.setInfluencedResponses((Long)jsonParser.readValueAs(Long.TYPE));
    }

    public void readPlatforms(JsonParser jsonParser) throws IOException {
        Map obj = (Map)jsonParser.readValueAs((TypeReference)new TypeReference<Map<String, PerPushCounts>>(){});
        for (String s : obj.keySet()) {
            PlatformType type = (PlatformType)((Object)PlatformType.find(s).get());
            this.builder.addPlatform(type, (PerPushCounts)obj.get(s));
        }
    }

    @Override
    public PerPushDetailResponse validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }
}

