/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.reports.parse;

import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.DateFormats;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.reports.model.PerPushSeriesResponse;
import com.urbanairship.api.reports.model.PlatformCounts;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerPushSeriesResponseReader
implements JsonObjectReader<PerPushSeriesResponse> {
    private final PerPushSeriesResponse.Builder builder = PerPushSeriesResponse.newBuilder();

    public void readAppKey(JsonParser jsonParser) throws IOException {
        this.builder.setAppKey((String)jsonParser.readValueAs(String.class));
    }

    public void readPushID(JsonParser jsonParser) throws IOException {
        this.builder.setPushID((UUID)jsonParser.readValueAs(UUID.class));
    }

    public void readStart(JsonParser jsonParser) throws IOException {
        String created = (String)jsonParser.readValueAs(String.class);
        this.builder.setStart(DateFormats.DATE_PARSER.parseDateTime(created));
    }

    public void readEnd(JsonParser jsonParser) throws IOException {
        String created = (String)jsonParser.readValueAs(String.class);
        this.builder.setEnd(DateFormats.DATE_PARSER.parseDateTime(created));
    }

    public void readPrecision(JsonParser jsonParser) throws IOException {
        this.builder.setPrecision((String)jsonParser.readValueAs(String.class));
    }

    public void readCounts(JsonParser jsonParser) throws IOException {
        List counts = (List)jsonParser.readValueAs((TypeReference)new TypeReference<List<PlatformCounts>>(){});
        this.builder.addAllPlatformCounts(counts);
    }

    @Override
    public PerPushSeriesResponse validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }
}

